/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class Throwables {
    private Throwables() {
    }

    public static <X extends Throwable> void propagateIfInstanceOf(@Nullable Throwable throwable2, Class<X> declaredType) throws X {
        if (throwable2 != null && declaredType.isInstance(throwable2)) {
            throw (Throwable)declaredType.cast(throwable2);
        }
    }

    public static void propagateIfPossible(@Nullable Throwable throwable2) {
        Throwables.propagateIfInstanceOf(throwable2, Error.class);
        Throwables.propagateIfInstanceOf(throwable2, RuntimeException.class);
    }

    public static <X extends Throwable> void propagateIfPossible(@Nullable Throwable throwable2, Class<X> declaredType) throws X {
        Throwables.propagateIfInstanceOf(throwable2, declaredType);
        Throwables.propagateIfPossible(throwable2);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@Nullable Throwable throwable2, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        Preconditions.checkNotNull(declaredType2);
        Throwables.propagateIfInstanceOf(throwable2, declaredType1);
        Throwables.propagateIfPossible(throwable2, declaredType2);
    }

    public static RuntimeException propagate(Throwable throwable2) {
        Throwables.propagateIfPossible(Preconditions.checkNotNull(throwable2));
        throw new RuntimeException(throwable2);
    }

    public static Throwable getRootCause(Throwable throwable2) {
        Throwable cause;
        while ((cause = throwable2.getCause()) != null) {
            throwable2 = cause;
        }
        return throwable2;
    }

    @Beta
    public static List<Throwable> getCausalChain(Throwable throwable2) {
        Preconditions.checkNotNull(throwable2);
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        while (throwable2 != null) {
            causes.add(throwable2);
            throwable2 = throwable2.getCause();
        }
        return Collections.unmodifiableList(causes);
    }

    public static String getStackTraceAsString(Throwable throwable2) {
        StringWriter stringWriter = new StringWriter();
        throwable2.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

