/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.org.jsoup.helper;

import coursier.shaded.org.jsoup.helper.StringUtil;
import coursier.shaded.org.jsoup.helper.Validate;
import coursier.shaded.org.jsoup.nodes.Attribute;
import coursier.shaded.org.jsoup.nodes.Attributes;
import coursier.shaded.org.jsoup.nodes.DataNode;
import coursier.shaded.org.jsoup.nodes.Node;
import coursier.shaded.org.jsoup.nodes.TextNode;
import coursier.shaded.org.jsoup.select.NodeTraversor;
import coursier.shaded.org.jsoup.select.NodeVisitor;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public Document fromJsoup(coursier.shaded.org.jsoup.nodes.Document in2) {
        Validate.notNull(in2);
        try {
            this.factory.setNamespaceAware(true);
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document out2 = builder.newDocument();
            this.convert(in2, out2);
            return out2;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void convert(coursier.shaded.org.jsoup.nodes.Document in2, Document out2) {
        if (!StringUtil.isBlank(in2.location())) {
            out2.setDocumentURI(in2.location());
        }
        coursier.shaded.org.jsoup.nodes.Element rootEl = in2.child(0);
        NodeTraversor traversor = new NodeTraversor(new W3CBuilder(out2));
        traversor.traverse(rootEl);
    }

    public String asString(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer2 = new StringWriter();
            StreamResult result2 = new StreamResult(writer2);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result2);
            return writer2.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final Document doc;
        private final HashMap<String, String> namespaces = new HashMap();
        private Element dest;

        public W3CBuilder(Document doc) {
            this.doc = doc;
        }

        public void head(Node source, int depth) {
            if (source instanceof coursier.shaded.org.jsoup.nodes.Element) {
                coursier.shaded.org.jsoup.nodes.Element sourceEl = (coursier.shaded.org.jsoup.nodes.Element)source;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace = this.namespaces.get(prefix);
                Element el = this.doc.createElementNS(namespace, sourceEl.tagName());
                this.copyAttributes(sourceEl, el);
                if (this.dest == null) {
                    this.doc.appendChild(el);
                } else {
                    this.dest.appendChild(el);
                }
                this.dest = el;
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                Text text2 = this.doc.createTextNode(sourceText.getWholeText());
                this.dest.appendChild(text2);
            } else if (source instanceof coursier.shaded.org.jsoup.nodes.Comment) {
                coursier.shaded.org.jsoup.nodes.Comment sourceComment = (coursier.shaded.org.jsoup.nodes.Comment)source;
                Comment comment = this.doc.createComment(sourceComment.getData());
                this.dest.appendChild(comment);
            } else if (source instanceof DataNode) {
                DataNode sourceData = (DataNode)source;
                Text node4 = this.doc.createTextNode(sourceData.getWholeData());
                this.dest.appendChild(node4);
            }
        }

        public void tail(Node source, int depth) {
            if (source instanceof coursier.shaded.org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
        }

        private void copyAttributes(Node source, Element el) {
            for (Attribute attribute : source.attributes()) {
                String key = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                if (!key.matches("[a-zA-Z_:]{1}[-a-zA-Z0-9_:.]*")) continue;
                el.setAttribute(key, attribute.getValue());
            }
        }

        private String updateNamespaces(coursier.shaded.org.jsoup.nodes.Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key = attr.getKey();
                if (key.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!key.startsWith(xmlnsPrefix)) continue;
                    prefix = key.substring(xmlnsPrefix.length());
                }
                this.namespaces.put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf(":");
            return pos > 0 ? el.tagName().substring(0, pos) : "";
        }
    }
}

