/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.annotation.AbstractMergedAnnotation;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationTypeMapping;
import org.springframework.core.annotation.AnnotationTypeMappings;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.IntrospectionFailureLogger;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.SynthesizedMergedAnnotationInvocationHandler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

final class TypeMappedAnnotation<A extends Annotation>
extends AbstractMergedAnnotation<A> {
    private static final Map<Class<?>, Object> EMPTY_ARRAYS;
    private final AnnotationTypeMapping mapping;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final Object source;
    @Nullable
    private final Object rootAttributes;
    private final BiFunction<Method, Object, Object> valueExtractor;
    private final int aggregateIndex;
    private final boolean useMergedValues;
    @Nullable
    private final Predicate<String> attributeFilter;
    private final int[] resolvedRootMirrors;
    private final int[] resolvedMirrors;
    @Nullable
    private String string;

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAttributes, BiFunction<Method, Object, Object> valueExtractor, int aggregateIndex) {
        this(mapping, classLoader, source, rootAttributes, valueExtractor, aggregateIndex, null);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAttributes, BiFunction<Method, Object, Object> valueExtractor, int aggregateIndex, @Nullable int[] resolvedRootMirrors) {
        this.mapping = mapping;
        this.classLoader = classLoader;
        this.source = source;
        this.rootAttributes = rootAttributes;
        this.valueExtractor = valueExtractor;
        this.aggregateIndex = aggregateIndex;
        this.useMergedValues = true;
        this.attributeFilter = null;
        this.resolvedRootMirrors = resolvedRootMirrors != null ? resolvedRootMirrors : mapping.getRoot().getMirrorSets().resolve(source, rootAttributes, this.valueExtractor);
        this.resolvedMirrors = this.getDistance() == 0 ? this.resolvedRootMirrors : mapping.getMirrorSets().resolve(source, this, this::getValueForMirrorResolution);
    }

    private TypeMappedAnnotation(AnnotationTypeMapping mapping, @Nullable ClassLoader classLoader, @Nullable Object source, @Nullable Object rootAnnotation, BiFunction<Method, Object, Object> valueExtractor, int aggregateIndex, boolean useMergedValues, @Nullable Predicate<String> attributeFilter, int[] resolvedRootMirrors, int[] resolvedMirrors) {
        this.classLoader = classLoader;
        this.source = source;
        this.rootAttributes = rootAnnotation;
        this.valueExtractor = valueExtractor;
        this.mapping = mapping;
        this.aggregateIndex = aggregateIndex;
        this.useMergedValues = useMergedValues;
        this.attributeFilter = attributeFilter;
        this.resolvedRootMirrors = resolvedRootMirrors;
        this.resolvedMirrors = resolvedMirrors;
    }

    @Override
    public Class<A> getType() {
        return this.mapping.getAnnotationType();
    }

    @Override
    public List<Class<? extends Annotation>> getMetaTypes() {
        return this.mapping.getMetaTypes();
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public int getDistance() {
        return this.mapping.getDistance();
    }

    @Override
    public int getAggregateIndex() {
        return this.aggregateIndex;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public MergedAnnotation<?> getMetaSource() {
        AnnotationTypeMapping metaSourceMapping = this.mapping.getSource();
        if (metaSourceMapping == null) {
            return null;
        }
        return new TypeMappedAnnotation<A>(metaSourceMapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public MergedAnnotation<?> getRoot() {
        if (this.getDistance() == 0) {
            return this;
        }
        AnnotationTypeMapping rootMapping = this.mapping.getRoot();
        return new TypeMappedAnnotation<A>(rootMapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.resolvedRootMirrors);
    }

    @Override
    public boolean hasDefaultValue(String attributeName) {
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Object value2 = this.getValue(attributeIndex, true, false);
        return value2 == null || this.mapping.isEquivalentToDefaultValue(attributeIndex, value2, this.valueExtractor);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String attributeName, Class<T> type) throws NoSuchElementException {
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Method attribute = this.mapping.getAttributes().get(attributeIndex);
        Assert.notNull(type, "Type must not be null");
        Assert.isAssignable(type, attribute.getReturnType(), () -> "Attribute " + attributeName + " type mismatch:");
        return (MergedAnnotation)this.getRequiredValue(attributeIndex, attributeName);
    }

    @Override
    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String attributeName, Class<T> type) throws NoSuchElementException {
        int attributeIndex = this.getAttributeIndex(attributeName, true);
        Method attribute = this.mapping.getAttributes().get(attributeIndex);
        Class<?> componentType = attribute.getReturnType().getComponentType();
        Assert.notNull(type, "Type must not be null");
        Assert.notNull(componentType, () -> "Attribute " + attributeName + " is not an array");
        Assert.isAssignable(type, componentType, () -> "Attribute " + attributeName + " component type mismatch:");
        return (MergedAnnotation[])this.getRequiredValue(attributeIndex, attributeName);
    }

    @Override
    public <T> Optional<T> getDefaultValue(String attributeName, Class<T> type) {
        int attributeIndex = this.getAttributeIndex(attributeName, false);
        if (attributeIndex == -1) {
            return Optional.empty();
        }
        Method attribute = this.mapping.getAttributes().get(attributeIndex);
        return Optional.ofNullable(this.adapt(attribute, attribute.getDefaultValue(), type));
    }

    @Override
    public MergedAnnotation<A> filterAttributes(Predicate<String> predicate) {
        if (this.attributeFilter != null) {
            predicate = this.attributeFilter.and(predicate);
        }
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, this.useMergedValues, predicate, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public MergedAnnotation<A> withNonMergedAttributes() {
        return new TypeMappedAnnotation<A>(this.mapping, this.classLoader, this.source, this.rootAttributes, this.valueExtractor, this.aggregateIndex, false, this.attributeFilter, this.resolvedRootMirrors, this.resolvedMirrors);
    }

    @Override
    public Map<String, Object> asMap(MergedAnnotation.Adapt ... adaptations) {
        return Collections.unmodifiableMap(this.asMap((MergedAnnotation<?> mergedAnnotation) -> new LinkedHashMap(), adaptations));
    }

    @Override
    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt ... adaptations) {
        Map map2 = (Map)factory.apply(this);
        Assert.state(map2 != null, "Factory used to create MergedAnnotation Map must not return null");
        AttributeMethods attributes = this.mapping.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Object value2;
            Method attribute = attributes.get(i);
            Object v0 = value2 = this.isFiltered(attribute.getName()) ? null : this.getValue(i, this.getTypeForMapOptions(attribute, adaptations));
            if (value2 == null) continue;
            map2.put(attribute.getName(), this.adaptValueForMapOptions(attribute, value2, map2.getClass(), factory, adaptations));
        }
        return (T)map2;
    }

    private Class<?> getTypeForMapOptions(Method attribute, MergedAnnotation.Adapt[] adaptations) {
        Class<?> componentType;
        Class<?> attributeType = attribute.getReturnType();
        Class<?> clazz = componentType = attributeType.isArray() ? attributeType.getComponentType() : attributeType;
        if (MergedAnnotation.Adapt.CLASS_TO_STRING.isIn(adaptations) && componentType == Class.class) {
            return attributeType.isArray() ? String[].class : String.class;
        }
        return Object.class;
    }

    private <T extends Map<String, Object>> Object adaptValueForMapOptions(Method attribute, Object value2, Class<?> mapType, Function<MergedAnnotation<?>, T> factory, MergedAnnotation.Adapt[] adaptations) {
        if (value2 instanceof MergedAnnotation) {
            MergedAnnotation annotation = (MergedAnnotation)value2;
            return MergedAnnotation.Adapt.ANNOTATION_TO_MAP.isIn(adaptations) ? annotation.asMap(factory, adaptations) : annotation.synthesize();
        }
        if (value2 instanceof MergedAnnotation[]) {
            MergedAnnotation[] annotations = (MergedAnnotation[])value2;
            if (MergedAnnotation.Adapt.ANNOTATION_TO_MAP.isIn(adaptations)) {
                Object result2 = Array.newInstance(mapType, annotations.length);
                for (int i = 0; i < annotations.length; ++i) {
                    Array.set(result2, i, annotations[i].asMap(factory, adaptations));
                }
                return result2;
            }
            Object result3 = Array.newInstance(attribute.getReturnType().getComponentType(), annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Array.set(result3, i, annotations[i].synthesize());
            }
            return result3;
        }
        return value2;
    }

    @Override
    protected A createSynthesized() {
        return SynthesizedMergedAnnotationInvocationHandler.createProxy(this, this.getType());
    }

    public String toString() {
        String string2 = this.string;
        if (string2 == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("@");
            builder.append(this.getType().getName());
            builder.append("(");
            for (int i = 0; i < this.mapping.getAttributes().size(); ++i) {
                Method attribute = this.mapping.getAttributes().get(i);
                builder.append(i == 0 ? "" : ", ");
                builder.append(attribute.getName());
                builder.append("=");
                builder.append(this.toString(this.getValue(i, Object.class)));
            }
            builder.append(")");
            this.string = string2 = builder.toString();
        }
        return string2;
    }

    private Object toString(@Nullable Object value2) {
        if (value2 == null) {
            return "";
        }
        if (value2 instanceof Class) {
            return ((Class)value2).getName();
        }
        if (value2.getClass().isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < Array.getLength(value2); ++i) {
                builder.append(i == 0 ? "" : ", ");
                builder.append(this.toString(Array.get(value2, i)));
            }
            builder.append("]");
            return builder.toString();
        }
        return String.valueOf(value2);
    }

    @Override
    @Nullable
    protected <T> T getAttributeValue(String attributeName, Class<T> type) {
        int attributeIndex = this.getAttributeIndex(attributeName, false);
        return attributeIndex != -1 ? (T)this.getValue(attributeIndex, type) : null;
    }

    private Object getRequiredValue(int attributeIndex, String attributeName) {
        Object value2 = this.getValue(attributeIndex, Object.class);
        if (value2 == null) {
            throw new NoSuchElementException("No element at attribute index " + attributeIndex + " for name " + attributeName);
        }
        return value2;
    }

    @Nullable
    private <T> T getValue(int attributeIndex, Class<T> type) {
        Method attribute = this.mapping.getAttributes().get(attributeIndex);
        Object value2 = this.getValue(attributeIndex, true, false);
        if (value2 == null) {
            value2 = attribute.getDefaultValue();
        }
        return this.adapt(attribute, value2, type);
    }

    @Nullable
    private Object getValue(int attributeIndex, boolean useConventionMapping, boolean forMirrorResolution) {
        AnnotationTypeMapping mapping = this.mapping;
        if (this.useMergedValues) {
            int mappedIndex = this.mapping.getAliasMapping(attributeIndex);
            if (mappedIndex == -1 && useConventionMapping) {
                mappedIndex = this.mapping.getConventionMapping(attributeIndex);
            }
            if (mappedIndex != -1) {
                mapping = mapping.getRoot();
                attributeIndex = mappedIndex;
            }
        }
        if (!forMirrorResolution) {
            attributeIndex = (mapping.getDistance() != 0 ? this.resolvedMirrors : this.resolvedRootMirrors)[attributeIndex];
        }
        if (attributeIndex == -1) {
            return null;
        }
        if (mapping.getDistance() == 0) {
            Method attribute = mapping.getAttributes().get(attributeIndex);
            Object result2 = this.valueExtractor.apply(attribute, this.rootAttributes);
            return result2 != null ? result2 : attribute.getDefaultValue();
        }
        return this.getValueFromMetaAnnotation(attributeIndex, forMirrorResolution);
    }

    @Nullable
    private Object getValueFromMetaAnnotation(int attributeIndex, boolean forMirrorResolution) {
        Object value2 = null;
        if (this.useMergedValues || forMirrorResolution) {
            value2 = this.mapping.getMappedAnnotationValue(attributeIndex, forMirrorResolution);
        }
        if (value2 == null) {
            Method attribute = this.mapping.getAttributes().get(attributeIndex);
            value2 = ReflectionUtils.invokeMethod(attribute, this.mapping.getAnnotation());
        }
        return value2;
    }

    @Nullable
    private Object getValueForMirrorResolution(Method attribute, Object annotation) {
        int attributeIndex = this.mapping.getAttributes().indexOf(attribute);
        boolean valueAttribute = "value".equals(attribute.getName());
        return this.getValue(attributeIndex, !valueAttribute, true);
    }

    @Nullable
    private <T> T adapt(Method attribute, @Nullable Object value2, Class<T> type) {
        if (value2 == null) {
            return null;
        }
        value2 = this.adaptForAttribute(attribute, value2);
        type = this.getAdaptType(attribute, type);
        if (value2 instanceof Class && type == String.class) {
            value2 = ((Class)value2).getName();
        } else if (value2 instanceof String && type == Class.class) {
            value2 = ClassUtils.resolveClassName((String)value2, this.getClassLoader());
        } else if (value2 instanceof Class[] && type == String[].class) {
            Class[] classes = (Class[])value2;
            String[] names = new String[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                names[i] = classes[i].getName();
            }
            value2 = names;
        } else if (value2 instanceof String[] && type == Class[].class) {
            String[] names = (String[])value2;
            Class[] classes = new Class[names.length];
            for (int i = 0; i < names.length; ++i) {
                classes[i] = ClassUtils.resolveClassName(names[i], this.getClassLoader());
            }
            value2 = classes;
        } else if (value2 instanceof MergedAnnotation && type.isAnnotation()) {
            MergedAnnotation annotation = (MergedAnnotation)value2;
            value2 = annotation.synthesize();
        } else if (value2 instanceof MergedAnnotation[] && type.isArray() && type.getComponentType().isAnnotation()) {
            MergedAnnotation[] annotations = (MergedAnnotation[])value2;
            Object array = Array.newInstance(type.getComponentType(), annotations.length);
            for (int i = 0; i < annotations.length; ++i) {
                Array.set(array, i, annotations[i].synthesize());
            }
            value2 = array;
        }
        if (!type.isInstance(value2)) {
            throw new IllegalArgumentException("Unable to adapt value of type " + value2.getClass().getName() + " to " + type.getName());
        }
        return (T)value2;
    }

    private Object adaptForAttribute(Method attribute, Object value2) {
        Class<?> attributeType = ClassUtils.resolvePrimitiveIfNecessary(attribute.getReturnType());
        if (attributeType.isArray() && !value2.getClass().isArray()) {
            Object array = Array.newInstance(value2.getClass(), 1);
            Array.set(array, 0, value2);
            return this.adaptForAttribute(attribute, array);
        }
        if (attributeType.isAnnotation()) {
            return this.adaptToMergedAnnotation(value2, attributeType);
        }
        if (attributeType.isArray() && attributeType.getComponentType().isAnnotation() && value2.getClass().isArray()) {
            MergedAnnotation[] result2 = new MergedAnnotation[Array.getLength(value2)];
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = this.adaptToMergedAnnotation(Array.get(value2, i), attributeType.getComponentType());
            }
            return result2;
        }
        if (attributeType == Class.class && value2 instanceof String || attributeType == Class[].class && value2 instanceof String[] || attributeType == String.class && value2 instanceof Class || attributeType == String[].class && value2 instanceof Class[]) {
            return value2;
        }
        if (attributeType.isArray() && this.isEmptyObjectArray(value2)) {
            return this.emptyArray(attributeType.getComponentType());
        }
        if (!attributeType.isInstance(value2)) {
            throw new IllegalStateException("Attribute '" + attribute.getName() + "' in annotation " + this.getType().getName() + " should be compatible with " + attributeType.getName() + " but a " + value2.getClass().getName() + " value was returned");
        }
        return value2;
    }

    private boolean isEmptyObjectArray(Object value2) {
        return value2 instanceof Object[] && ((Object[])value2).length == 0;
    }

    private Object emptyArray(Class<?> componentType) {
        Object result2 = EMPTY_ARRAYS.get(componentType);
        if (result2 == null) {
            result2 = Array.newInstance(componentType, 0);
        }
        return result2;
    }

    private MergedAnnotation<?> adaptToMergedAnnotation(Object value2, Class<? extends Annotation> annotationType) {
        if (value2 instanceof MergedAnnotation) {
            return (MergedAnnotation)value2;
        }
        AnnotationTypeMapping mapping = AnnotationTypeMappings.forAnnotationType(annotationType).get(0);
        return new TypeMappedAnnotation<A>(mapping, null, this.source, value2, this.getValueExtractor(value2), this.aggregateIndex);
    }

    private BiFunction<Method, Object, Object> getValueExtractor(Object value2) {
        if (value2 instanceof Annotation) {
            return ReflectionUtils::invokeMethod;
        }
        if (value2 instanceof Map) {
            return TypeMappedAnnotation::extractFromMap;
        }
        return this.valueExtractor;
    }

    private <T> Class<T> getAdaptType(Method attribute, Class<T> type) {
        if (type != Object.class) {
            return type;
        }
        Class<?> attributeType = attribute.getReturnType();
        if (attributeType.isAnnotation()) {
            return MergedAnnotation.class;
        }
        if (attributeType.isArray() && attributeType.getComponentType().isAnnotation()) {
            return MergedAnnotation[].class;
        }
        return ClassUtils.resolvePrimitiveIfNecessary(attributeType);
    }

    private int getAttributeIndex(String attributeName, boolean required) {
        int attributeIndex;
        Assert.hasText(attributeName, "Attribute name must not be null");
        int n = attributeIndex = this.isFiltered(attributeName) ? -1 : this.mapping.getAttributes().indexOf(attributeName);
        if (attributeIndex == -1 && required) {
            throw new NoSuchElementException("No attribute named '" + attributeName + "' present in merged annotation " + this.getType().getName());
        }
        return attributeIndex;
    }

    private boolean isFiltered(String attributeName) {
        if (this.attributeFilter != null) {
            return !this.attributeFilter.test(attributeName);
        }
        return false;
    }

    @Nullable
    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.source != null) {
            if (this.source instanceof Class) {
                return ((Class)this.source).getClassLoader();
            }
            if (this.source instanceof Member) {
                ((Member)this.source).getDeclaringClass().getClassLoader();
            }
        }
        return null;
    }

    static <A extends Annotation> MergedAnnotation<A> from(@Nullable Object source, A annotation) {
        Assert.notNull(annotation, "Annotation must not be null");
        AnnotationTypeMappings mappings2 = AnnotationTypeMappings.forAnnotationType(annotation.annotationType());
        return new TypeMappedAnnotation<A>(mappings2.get(0), null, source, annotation, ReflectionUtils::invokeMethod, 0);
    }

    static <A extends Annotation> MergedAnnotation<A> of(@Nullable ClassLoader classLoader, @Nullable Object source, Class<A> annotationType, @Nullable Map<String, ?> attributes) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        AnnotationTypeMappings mappings2 = AnnotationTypeMappings.forAnnotationType(annotationType);
        return new TypeMappedAnnotation<A>(mappings2.get(0), classLoader, source, attributes, TypeMappedAnnotation::extractFromMap, 0);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, MergedAnnotation<?> annotation, IntrospectionFailureLogger logger) {
        if (annotation instanceof TypeMappedAnnotation) {
            TypeMappedAnnotation typeMappedAnnotation = (TypeMappedAnnotation)annotation;
            return TypeMappedAnnotation.createIfPossible(mapping, typeMappedAnnotation.source, typeMappedAnnotation.rootAttributes, typeMappedAnnotation.valueExtractor, typeMappedAnnotation.aggregateIndex, logger);
        }
        return TypeMappedAnnotation.createIfPossible(mapping, annotation.getSource(), annotation.synthesize(), annotation.getAggregateIndex(), logger);
    }

    @Nullable
    static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, @Nullable Object source, Annotation annotation, int aggregateIndex, IntrospectionFailureLogger logger) {
        return TypeMappedAnnotation.createIfPossible(mapping, source, annotation, ReflectionUtils::invokeMethod, aggregateIndex, logger);
    }

    @Nullable
    private static <A extends Annotation> TypeMappedAnnotation<A> createIfPossible(AnnotationTypeMapping mapping, @Nullable Object source, @Nullable Object rootAttribute, BiFunction<Method, Object, Object> valueExtractor, int aggregateIndex, IntrospectionFailureLogger logger) {
        try {
            return new TypeMappedAnnotation<A>(mapping, null, source, rootAttribute, valueExtractor, aggregateIndex);
        }
        catch (Exception ex) {
            if (ex instanceof AnnotationConfigurationException) {
                throw (AnnotationConfigurationException)ex;
            }
            if (logger.isEnabled()) {
                String type = mapping.getAnnotationType().getName();
                String item = mapping.getDistance() == 0 ? "annotation " + type : "meta-annotation " + type + " from " + mapping.getRoot().getAnnotationType().getName();
                logger.log("Failed to introspect " + item, source, ex);
            }
            return null;
        }
    }

    @Nullable
    private static Object extractFromMap(Method attribute, @Nullable Object map2) {
        return map2 != null ? ((Map)map2).get(attribute.getName()) : null;
    }

    static {
        HashMap<Class<Comparable<Byte>>, Object[]> emptyArrays = new HashMap<Class<Comparable<Byte>>, Object[]>();
        emptyArrays.put(String.class, new String[0]);
        emptyArrays.put(Boolean.TYPE, new boolean[0]);
        emptyArrays.put(Byte.TYPE, new byte[0]);
        emptyArrays.put(Character.TYPE, new char[0]);
        emptyArrays.put(Double.TYPE, new double[0]);
        emptyArrays.put(Float.TYPE, new float[0]);
        emptyArrays.put(Integer.TYPE, new int[0]);
        emptyArrays.put(Long.TYPE, new long[0]);
        emptyArrays.put(Short.TYPE, new short[0]);
        EMPTY_ARRAYS = Collections.unmodifiableMap(emptyArrays);
    }
}

