/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zmq.Msg;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.Metadata;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.socket.Sockets;
import zmq.util.Blob;
import zmq.util.Wire;

public abstract class Mechanism {
    protected final Options options;
    private Blob identity;
    private Blob userId;
    public final Metadata zapProperties = new Metadata();
    public final Metadata zmtpProperties = new Metadata();
    protected final SessionBase session;
    private final Address peerAddress;
    protected String statusCode;

    protected Mechanism(SessionBase session, Address peerAddress, Options options2) {
        this.session = session;
        this.options = options2;
        this.peerAddress = peerAddress;
    }

    public abstract Status status();

    private void setPeerIdentity(byte[] data) {
        this.identity = Blob.createBlob(data);
    }

    public final Msg peerIdentity() {
        Msg msg = new Msg(this.identity == null ? 0 : this.identity.size());
        msg.put(this.identity.data(), 0, this.identity.size());
        msg.setFlags(64);
        return msg;
    }

    private void setUserId(byte[] data) {
        this.userId = Blob.createBlob(data);
        this.zapProperties.set("User-Id", new String(data, ZMQ.CHARSET));
    }

    public final Blob getUserId() {
        return this.userId;
    }

    protected final void addProperty(ByteBuffer buf, String name, String value2) {
        this.addProperty(buf, name, value2.getBytes(ZMQ.CHARSET));
    }

    protected final void addProperty(Msg msg, String name, String value2) {
        this.addProperty(msg, name, value2.getBytes(ZMQ.CHARSET));
    }

    protected final void addProperty(ByteBuffer buf, String name, byte[] value2) {
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int valueLength = value2 == null ? 0 : value2.length;
        buf.put((byte)nameLength);
        buf.put(nameB);
        Wire.putUInt32(buf, valueLength);
        if (value2 != null) {
            buf.put(value2);
        }
    }

    protected final void addProperty(Msg msg, String name, byte[] value2) {
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int valueLength = value2 == null ? 0 : value2.length;
        msg.put((byte)nameLength);
        msg.put(nameB);
        Wire.putUInt32(msg, valueLength);
        if (value2 != null) {
            msg.put(value2);
        }
    }

    protected final int parseMetadata(Msg msg, int offset, boolean zapFlag) {
        return this.parseMetadata(msg.buf(), offset, zapFlag);
    }

    protected final int parseMetadata(ByteBuffer msg, int offset, boolean zapFlag) {
        Metadata meta = zapFlag ? this.zapProperties : this.zmtpProperties;
        return meta.read(msg, offset, new Metadata.ParseListener(){

            @Override
            public int parsed(String name, byte[] value2, String valueAsString) {
                if ("Identity".equals(name) && Mechanism.this.options.recvIdentity) {
                    Mechanism.this.setPeerIdentity(value2);
                } else if ("Socket-Type".equals(name)) {
                    if (!Sockets.compatible(Mechanism.this.options.type, valueAsString)) {
                        return 22;
                    }
                } else {
                    int rc = Mechanism.this.property(name, value2);
                    if (rc == -1) {
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    protected int property(String name, byte[] value2) {
        return 0;
    }

    protected final String socketType(int socketType) {
        return Sockets.name(this.options.type);
    }

    protected boolean compare(Msg msg, String data, boolean includeLength) {
        boolean comparison;
        int start2;
        int n = start2 = includeLength ? 1 : 0;
        if (msg.size() < data.length() + start2) {
            return false;
        }
        boolean bl = includeLength ? msg.get(0) == data.length() : (comparison = true);
        if (comparison) {
            for (int idx = start2; idx < data.length(); ++idx) {
                boolean bl2 = comparison = msg.get(idx) == data.charAt(idx - start2);
                if (!comparison) break;
            }
        }
        return comparison;
    }

    protected boolean compare(ByteBuffer a1, byte[] b2, int offset, int length2) {
        if (length2 > b2.length) {
            return false;
        }
        boolean comparison = true;
        for (int idx = 0; idx < length2; ++idx) {
            boolean bl = comparison = a1.get(idx + offset) == b2[idx];
            if (!comparison) break;
        }
        return comparison;
    }

    public Msg decode(Msg msg) {
        return msg;
    }

    public Msg encode(Msg msg) {
        return msg;
    }

    public abstract int zapMsgAvailable();

    public abstract int processHandshakeCommand(Msg var1);

    public abstract int nextHandshakeCommand(Msg var1);

    protected final void sendZapRequest(Mechanisms mechanism, boolean more) {
        assert (this.session != null);
        assert (this.peerAddress != null);
        assert (mechanism != null);
        Msg msg = new Msg();
        msg.setFlags(1);
        boolean rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(3);
        msg.setFlags(1);
        msg.put("1.0".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(1);
        msg.setFlags(1);
        msg.put("1".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.zapDomain.length());
        msg.setFlags(1);
        msg.put(this.options.zapDomain.getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        byte[] host = this.peerAddress.host().getBytes(ZMQ.CHARSET);
        msg = new Msg(host.length);
        msg.setFlags(1);
        msg.put(host);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.identitySize);
        msg.setFlags(1);
        msg.put(this.options.identity, 0, (int)this.options.identitySize);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(mechanism.name().length());
        msg.put(mechanism.name().getBytes(ZMQ.CHARSET));
        if (more) {
            msg.setFlags(1);
        }
        rc = this.session.writeZapMsg(msg);
        assert (rc);
    }

    protected final int receiveAndProcessZapReply() {
        assert (this.session != null);
        ArrayList<Msg> msgs = new ArrayList<Msg>(7);
        for (int idx = 0; idx < 7; ++idx) {
            Msg msg = this.session.readZapMsg();
            if (msg == null) {
                return this.session.errno.get();
            }
            if ((msg.flags() & 1) == (idx < 6 ? 0 : 1)) {
                this.puts("NULL I: ZAP handler sent incomplete reply message " + msg);
                return 156384820;
            }
            msgs.add(msg);
        }
        if (((Msg)msgs.get(0)).size() > 0) {
            this.puts("NULL I: ZAP handler sent malformed reply message in address delimiter frame " + msgs.get(0));
            return 156384820;
        }
        if (((Msg)msgs.get(1)).size() != 3 || !this.compare((Msg)msgs.get(1), "1.0", false)) {
            this.puts("NULL I: ZAP handler sent bad version number " + msgs.get(1));
            return 156384820;
        }
        if (((Msg)msgs.get(2)).size() != 1 || !this.compare((Msg)msgs.get(2), "1", false)) {
            this.puts("NULL I: ZAP handler sent bad request ID " + msgs.get(2));
            return 156384820;
        }
        if (((Msg)msgs.get(3)).size() != 3) {
            this.puts("NULL I: ZAP handler rejected client authentication " + msgs.get(3));
            return 156384820;
        }
        this.statusCode = new String(((Msg)msgs.get(3)).data(), ZMQ.CHARSET);
        this.setUserId(((Msg)msgs.get(5)).data());
        return this.parseMetadata((Msg)msgs.get(6), 0, true);
    }

    protected final void puts(String msg) {
        System.out.println(this.session + " " + msg);
    }

    protected final void appendData(Msg msg, String data) {
        msg.put((byte)data.length());
        msg.put(data.getBytes(ZMQ.CHARSET));
    }

    public void destroy() {
    }

    public static enum Status {
        HANDSHAKING,
        READY,
        ERROR;

    }
}

