/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class QueryDataSetUtils {
    private static final int FLAG = 1;

    private QueryDataSetUtils() {
    }

    public static Pair<TSQueryDataSet, Boolean> convertTsBlockByFetchSize(IQueryExecution queryExecution, int fetchSize) throws IOException, IoTDBException {
        boolean finished = false;
        int columnNum = queryExecution.getOutputValueColumnCount();
        int columnNumWithTime = columnNum * 2 + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int[] valueOccupation = new int[columnNum];
        int[] bitmaps = new int[columnNum];
        while (rowCount < fetchSize) {
            Optional<TsBlock> optionalTsBlock = queryExecution.getBatchResult();
            if (!optionalTsBlock.isPresent()) {
                finished = true;
                break;
            }
            TsBlock tsBlock = optionalTsBlock.get();
            if (tsBlock.isEmpty()) continue;
            int currentCount = tsBlock.getPositionCount();
            QueryDataSetUtils.serializeTsBlock(rowCount, currentCount, tsBlock, columnNum, dataOutputStreams, valueOccupation, bitmaps);
            rowCount += currentCount;
        }
        QueryDataSetUtils.fillRemainingBitMap(rowCount, columnNum, dataOutputStreams, bitmaps);
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        QueryDataSetUtils.fillTimeColumn(rowCount, byteArrayOutputStreams, tsQueryDataSet);
        QueryDataSetUtils.fillValueColumnsAndBitMaps(rowCount, byteArrayOutputStreams, valueOccupation, tsQueryDataSet);
        return new Pair((Object)tsQueryDataSet, (Object)finished);
    }

    public static TSQueryDataSet convertTsBlockByFetchSize(List<TsBlock> tsBlocks) throws IOException {
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnNum = 1;
        int columnNumWithTime = columnNum * 2 + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int[] valueOccupation = new int[columnNum];
        int[] bitmaps = new int[columnNum];
        for (TsBlock tsBlock : tsBlocks) {
            if (tsBlock.isEmpty()) continue;
            int currentCount = tsBlock.getPositionCount();
            for (int i = 0; i < currentCount; ++i) {
                dataOutputStreams[0].writeLong(tsBlock.getTimeByIndex(i));
            }
            for (int k = 0; k < columnNum; ++k) {
                DataOutputStream dataOutputStream = dataOutputStreams[2 * k + 1];
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
                Column column = tsBlock.getColumn(k);
                TSDataType type = column.getDataType();
                switch (type) {
                    case INT32: 
                    case DATE: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeInt(column.getInt(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 4;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeLong(column.getLong(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 8;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case FLOAT: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeFloat(column.getFloat(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 4;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeDouble(column.getDouble(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 8;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case BOOLEAN: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeBoolean(column.getBoolean(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 1;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                Binary binary = column.getBinary(i);
                                dataOutputStream.writeInt(binary.getLength());
                                dataOutputStream.write(binary.getValues());
                                valueOccupation[k] = valueOccupation[k] + 4 + binary.getLength();
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
                if (k == columnNum - 1) continue;
                rowCount -= currentCount;
            }
        }
        int remaining = rowCount % 8;
        for (int k = 0; k < columnNum; ++k) {
            if (remaining == 0) continue;
            DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
            dataBitmapOutputStream.writeByte(bitmaps[k] << 8 - remaining);
        }
        int timeOccupation = rowCount * 8;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeOccupation);
        timeBuffer.put(byteArrayOutputStreams[0].toByteArray());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        int bitmapOccupation = (rowCount + 7) / 8;
        LinkedList<ByteBuffer> bitmapList = new LinkedList<ByteBuffer>();
        LinkedList<ByteBuffer> valueList = new LinkedList<ByteBuffer>();
        for (int i = 1; i < byteArrayOutputStreams.length; i += 2) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation[(i - 1) / 2]);
            valueBuffer.put(byteArrayOutputStreams[i].toByteArray());
            valueBuffer.flip();
            valueList.add(valueBuffer);
            ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapOccupation);
            bitmapBuffer.put(byteArrayOutputStreams[i + 1].toByteArray());
            bitmapBuffer.flip();
            bitmapList.add(bitmapBuffer);
        }
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
        return tsQueryDataSet;
    }

    private static void serializeTsBlock(int rowCount, int currentCount, TsBlock tsBlock, int columnNum, DataOutputStream[] dataOutputStreams, int[] valueOccupation, int[] bitmaps) throws IOException {
        for (int i = 0; i < currentCount; ++i) {
            dataOutputStreams[0].writeLong(tsBlock.getTimeByIndex(i));
        }
        block9: for (int k = 0; k < columnNum; ++k) {
            DataOutputStream dataOutputStream = dataOutputStreams[2 * k + 1];
            DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
            Column column = tsBlock.getColumn(k);
            TSDataType type = column.getDataType();
            switch (type) {
                case INT32: 
                case DATE: {
                    QueryDataSetUtils.doWithInt32Column(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    QueryDataSetUtils.doWithInt64Column(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                case FLOAT: {
                    QueryDataSetUtils.doWithFloatColumn(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                case DOUBLE: {
                    QueryDataSetUtils.doWithDoubleColumn(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                case BOOLEAN: {
                    QueryDataSetUtils.doWithBooleanColumn(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    QueryDataSetUtils.doWithTextColumn(rowCount, column, bitmaps, k, dataOutputStream, valueOccupation, dataBitmapOutputStream);
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                }
            }
        }
    }

    private static void doWithInt32Column(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                dataOutputStream.writeInt(column.getInt(i));
                int n = columnIndex;
                valueOccupation[n] = valueOccupation[n] + 4;
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void doWithInt64Column(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                dataOutputStream.writeLong(column.getLong(i));
                int n = columnIndex;
                valueOccupation[n] = valueOccupation[n] + 8;
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void doWithFloatColumn(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                dataOutputStream.writeFloat(column.getFloat(i));
                int n = columnIndex;
                valueOccupation[n] = valueOccupation[n] + 4;
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void doWithDoubleColumn(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                dataOutputStream.writeDouble(column.getDouble(i));
                int n = columnIndex;
                valueOccupation[n] = valueOccupation[n] + 8;
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void doWithBooleanColumn(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                dataOutputStream.writeBoolean(column.getBoolean(i));
                int n = columnIndex;
                valueOccupation[n] = valueOccupation[n] + 1;
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void doWithTextColumn(int rowCount, Column column, int[] bitmaps, int columnIndex, DataOutputStream dataOutputStream, int[] valueOccupation, DataOutputStream dataBitmapOutputStream) throws IOException {
        int size = column.getPositionCount();
        for (int i = 0; i < size; ++i) {
            ++rowCount;
            if (column.isNull(i)) {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1;
            } else {
                bitmaps[columnIndex] = bitmaps[columnIndex] << 1 | 1;
                Binary binary = column.getBinary(i);
                dataOutputStream.writeInt(binary.getLength());
                dataOutputStream.write(binary.getValues());
                valueOccupation[columnIndex] = valueOccupation[columnIndex] + 4 + binary.getLength();
            }
            if (rowCount == 0 || rowCount % 8 != 0) continue;
            dataBitmapOutputStream.writeByte(bitmaps[columnIndex]);
            bitmaps[columnIndex] = 0;
        }
    }

    private static void fillRemainingBitMap(int rowCount, int columnNum, DataOutputStream[] dataOutputStreams, int[] bitmaps) throws IOException {
        int remaining = rowCount % 8;
        for (int k = 0; k < columnNum; ++k) {
            if (remaining == 0) continue;
            DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
            dataBitmapOutputStream.writeByte(bitmaps[k] << 8 - remaining);
        }
    }

    private static void fillTimeColumn(int rowCount, ByteArrayOutputStream[] byteArrayOutputStreams, TSQueryDataSet tsQueryDataSet) {
        int timeOccupation = rowCount * 8;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeOccupation);
        timeBuffer.put(byteArrayOutputStreams[0].toByteArray());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
    }

    private static void fillValueColumnsAndBitMaps(int rowCount, ByteArrayOutputStream[] byteArrayOutputStreams, int[] valueOccupation, TSQueryDataSet tsQueryDataSet) {
        int bitmapOccupation = (rowCount + 7) / 8;
        LinkedList<ByteBuffer> bitmapList = new LinkedList<ByteBuffer>();
        LinkedList<ByteBuffer> valueList = new LinkedList<ByteBuffer>();
        for (int i = 1; i < byteArrayOutputStreams.length; i += 2) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation[(i - 1) / 2]);
            valueBuffer.put(byteArrayOutputStreams[i].toByteArray());
            valueBuffer.flip();
            valueList.add(valueBuffer);
            ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapOccupation);
            bitmapBuffer.put(byteArrayOutputStreams[i + 1].toByteArray());
            bitmapBuffer.flip();
            bitmapList.add(bitmapBuffer);
        }
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
    }

    public static Pair<List<ByteBuffer>, Boolean> convertQueryResultByFetchSize(IQueryExecution queryExecution, int fetchSize) throws IoTDBException {
        Optional<ByteBuffer> optionalByteBuffer;
        int positionCount;
        ArrayList<ByteBuffer> res = new ArrayList<ByteBuffer>();
        for (int rowCount = 0; rowCount < fetchSize && (optionalByteBuffer = queryExecution.getByteBufferBatchResult()).isPresent(); rowCount += positionCount) {
            ByteBuffer byteBuffer = optionalByteBuffer.get();
            byteBuffer.mark();
            int valueColumnCount = byteBuffer.getInt();
            for (int i = 0; i < valueColumnCount; ++i) {
                byteBuffer.get();
            }
            positionCount = byteBuffer.getInt();
            byteBuffer.reset();
            if (positionCount == 0) continue;
            res.add(byteBuffer);
        }
        return new Pair(res, (Object)(!queryExecution.hasNextResult() ? 1 : 0));
    }

    public static long[] readTimesFromBuffer(ByteBuffer buffer, int size) {
        long[] times = new long[size];
        for (int i = 0; i < size; ++i) {
            times[i] = buffer.getLong();
        }
        return times;
    }

    public static long[] readTimesFromStream(DataInputStream stream, int size) throws IOException {
        long[] times = new long[size];
        for (int i = 0; i < size; ++i) {
            times[i] = stream.readLong();
        }
        return times;
    }

    public static Optional<BitMap[]> readBitMapsFromBuffer(ByteBuffer buffer, int columns, int size) {
        if (!buffer.hasRemaining()) {
            return Optional.empty();
        }
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool((byte)buffer.get());
            if (!hasBitMap) continue;
            byte[] bytes = new byte[size / 8 + 1];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = buffer.get();
            }
            bitMaps[i] = new BitMap(size, bytes);
        }
        return Optional.of(bitMaps);
    }

    public static Optional<BitMap[]> readBitMapsFromStream(DataInputStream stream, int columns, int size) throws IOException {
        if (stream.available() <= 0) {
            return Optional.empty();
        }
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool((byte)stream.readByte());
            if (!hasBitMap) continue;
            byte[] bytes = new byte[size / 8 + 1];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = stream.readByte();
            }
            bitMaps[i] = new BitMap(size, bytes);
        }
        return Optional.of(bitMaps);
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer buffer, List<Integer> types, int columns, int size) {
        TSDataType[] dataTypes = new TSDataType[types.size()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = TSDataType.values()[types.get(i)];
        }
        return QueryDataSetUtils.readTabletValuesFromBuffer(buffer, dataTypes, columns, size);
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer buffer, TSDataType[] types, int columns, int size) {
        Object[] values = new Object[columns];
        block8: for (int i = 0; i < columns; ++i) {
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[size];
                    for (int index = 0; index < size; ++index) {
                        boolValues[index] = BytesUtils.byteToBool((byte)buffer.get());
                    }
                    values[i] = boolValues;
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    int[] intValues = new int[size];
                    for (int index = 0; index < size; ++index) {
                        intValues[index] = buffer.getInt();
                    }
                    values[i] = intValues;
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = new long[size];
                    for (int index = 0; index < size; ++index) {
                        longValues[index] = buffer.getLong();
                    }
                    values[i] = longValues;
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = new float[size];
                    for (int index = 0; index < size; ++index) {
                        floatValues[index] = buffer.getFloat();
                    }
                    values[i] = floatValues;
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[size];
                    for (int index = 0; index < size; ++index) {
                        doubleValues[index] = buffer.getDouble();
                    }
                    values[i] = doubleValues;
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary[] binaryValues = new Binary[size];
                    for (int index = 0; index < size; ++index) {
                        int binarySize = buffer.getInt();
                        byte[] binaryValue = new byte[binarySize];
                        buffer.get(binaryValue);
                        binaryValues[index] = new Binary(binaryValue);
                    }
                    values[i] = binaryValues;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }

    public static Object[] readTabletValuesFromStream(DataInputStream stream, TSDataType[] types, int columns, int size) throws IOException {
        Object[] values = new Object[columns];
        block8: for (int i = 0; i < columns; ++i) {
            switch (types[i]) {
                case BOOLEAN: {
                    QueryDataSetUtils.parseBooleanColumn(size, stream, values, i);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    QueryDataSetUtils.parseInt32Column(size, stream, values, i);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    QueryDataSetUtils.parseInt64Column(size, stream, values, i);
                    continue block8;
                }
                case FLOAT: {
                    QueryDataSetUtils.parseFloatColumn(size, stream, values, i);
                    continue block8;
                }
                case DOUBLE: {
                    QueryDataSetUtils.parseDoubleColumn(size, stream, values, i);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    QueryDataSetUtils.parseTextColumn(size, stream, values, i);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }

    private static void parseBooleanColumn(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        boolean[] boolValues = new boolean[size];
        for (int index = 0; index < size; ++index) {
            boolValues[index] = BytesUtils.byteToBool((byte)stream.readByte());
        }
        values[columnIndex] = boolValues;
    }

    private static void parseInt32Column(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        int[] intValues = new int[size];
        for (int index = 0; index < size; ++index) {
            intValues[index] = stream.readInt();
        }
        values[columnIndex] = intValues;
    }

    private static void parseInt64Column(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        long[] longValues = new long[size];
        for (int index = 0; index < size; ++index) {
            longValues[index] = stream.readLong();
        }
        values[columnIndex] = longValues;
    }

    private static void parseFloatColumn(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        float[] floatValues = new float[size];
        for (int index = 0; index < size; ++index) {
            floatValues[index] = stream.readFloat();
        }
        values[columnIndex] = floatValues;
    }

    private static void parseDoubleColumn(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        double[] doubleValues = new double[size];
        for (int index = 0; index < size; ++index) {
            doubleValues[index] = stream.readDouble();
        }
        values[columnIndex] = doubleValues;
    }

    private static void parseTextColumn(int size, DataInputStream stream, Object[] values, int columnIndex) throws IOException {
        Binary[] binaryValues = new Binary[size];
        for (int index = 0; index < size; ++index) {
            int binarySize = stream.readInt();
            byte[] binaryValue = new byte[binarySize];
            int actualReadSize = stream.read(binaryValue);
            if (actualReadSize != binarySize) {
                throw new IllegalStateException("Expect to read " + binarySize + " bytes, actually read " + actualReadSize + "bytes.");
            }
            binaryValues[index] = new Binary(binaryValue);
        }
        values[columnIndex] = binaryValues;
    }
}

