/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.IoTProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.SimpleProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.TimeWindowStateProgressIndex;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum ProgressIndexType {
    MINIMUM_PROGRESS_INDEX(1),
    IOT_PROGRESS_INDEX(2),
    SIMPLE_PROGRESS_INDEX(3),
    RECOVER_PROGRESS_INDEX(4),
    HYBRID_PROGRESS_INDEX(5),
    META_PROGRESS_INDEX(6),
    TIME_WINDOW_STATE_PROGRESS_INDEX(7),
    STATE_PROGRESS_INDEX(8);

    private final short type;

    private ProgressIndexType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((short)this.type, (ByteBuffer)byteBuffer);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.type, (OutputStream)stream);
    }

    public static ProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        short indexType = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
        switch (indexType) {
            case 1: {
                return MinimumProgressIndex.deserializeFrom(byteBuffer);
            }
            case 2: {
                return IoTProgressIndex.deserializeFrom(byteBuffer);
            }
            case 3: {
                return SimpleProgressIndex.deserializeFrom(byteBuffer);
            }
            case 4: {
                return RecoverProgressIndex.deserializeFrom(byteBuffer);
            }
            case 5: {
                return HybridProgressIndex.deserializeFrom(byteBuffer);
            }
            case 6: {
                return MetaProgressIndex.deserializeFrom(byteBuffer);
            }
            case 7: {
                return TimeWindowStateProgressIndex.deserializeFrom(byteBuffer);
            }
            case 8: {
                return StateProgressIndex.deserializeFrom(byteBuffer);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported progress index type %s.", indexType));
    }

    public static ProgressIndex deserializeFrom(InputStream stream) throws IOException {
        short indexType = ReadWriteIOUtils.readShort((InputStream)stream);
        switch (indexType) {
            case 1: {
                return MinimumProgressIndex.deserializeFrom(stream);
            }
            case 2: {
                return IoTProgressIndex.deserializeFrom(stream);
            }
            case 3: {
                return SimpleProgressIndex.deserializeFrom(stream);
            }
            case 4: {
                return RecoverProgressIndex.deserializeFrom(stream);
            }
            case 5: {
                return HybridProgressIndex.deserializeFrom(stream);
            }
            case 6: {
                return MetaProgressIndex.deserializeFrom(stream);
            }
            case 7: {
                return TimeWindowStateProgressIndex.deserializeFrom(stream);
            }
            case 8: {
                return StateProgressIndex.deserializeFrom(stream);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported progress index type %s.", indexType));
    }
}

