/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.operator;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.CompareNullFilter;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.read.filter.operator.ValueIsNullOperator;
import org.apache.tsfile.utils.Binary;

public class ValueIsNotNullOperator
extends CompareNullFilter {
    public ValueIsNotNullOperator(int measurementIndex) {
        super(measurementIndex);
    }

    public ValueIsNotNullOperator(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return value != null;
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return true;
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return true;
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return true;
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return true;
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return true;
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return value != null;
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = !valueColumn.isNull(i);
        }
        return satisfyInfo;
    }

    @Override
    public Filter reverse() {
        return new ValueIsNullOperator(this.measurementIndex);
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.VALUE_IS_NOT_NULL;
    }

    @Override
    public boolean valueSatisfy(Object value) {
        return false;
    }

    @Override
    public boolean canSkip(Statistics<? extends Serializable> statistics) {
        throw new NotImplementedException();
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        if (!statistics.isPresent()) {
            return true;
        }
        return statistics.get().getCount() == 0L;
    }

    @Override
    public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
        throw new NotImplementedException();
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        if (!statistics.isPresent()) {
            return false;
        }
        return !metadata.hasNullValue(this.measurementIndex);
    }
}

