/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.FixedSequenceGroup;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.Sequencer;

public class EventPoller<T> {
    private final DataProvider<T> dataProvider;
    private final Sequencer sequencer;
    private final Sequence sequence;
    private final Sequence gatingSequence;

    public EventPoller(DataProvider<T> dataProvider, Sequencer sequencer, Sequence sequence, Sequence gatingSequence) {
        this.dataProvider = dataProvider;
        this.sequencer = sequencer;
        this.sequence = sequence;
        this.gatingSequence = gatingSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollState poll(Handler<T> eventHandler) throws Exception {
        long availableSequence;
        long currentSequence = this.sequence.get();
        long nextSequence = currentSequence + 1L;
        if (nextSequence <= (availableSequence = this.sequencer.getHighestPublishedSequence(nextSequence, this.gatingSequence.get()))) {
            long processedSequence = currentSequence;
            try {
                boolean processNextEvent;
                do {
                    T event = this.dataProvider.get(nextSequence);
                    processNextEvent = eventHandler.onEvent(event, nextSequence, nextSequence == availableSequence);
                    processedSequence = nextSequence++;
                } while (nextSequence <= availableSequence & processNextEvent);
            }
            finally {
                this.sequence.set(processedSequence);
            }
            return PollState.PROCESSING;
        }
        if (this.sequencer.getCursor() >= nextSequence) {
            return PollState.GATING;
        }
        return PollState.IDLE;
    }

    public static <T> EventPoller<T> newInstance(DataProvider<T> dataProvider, Sequencer sequencer, Sequence sequence, Sequence cursorSequence, Sequence ... gatingSequences) {
        Sequence gatingSequence = gatingSequences.length == 0 ? cursorSequence : (gatingSequences.length == 1 ? gatingSequences[0] : new FixedSequenceGroup(gatingSequences));
        return new EventPoller<T>(dataProvider, sequencer, sequence, gatingSequence);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public static enum PollState {
        PROCESSING,
        GATING,
        IDLE;

    }

    public static interface Handler<T> {
        public boolean onEvent(T var1, long var2, boolean var4) throws Exception;
    }
}

