/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class SchemaUtils {
    private SchemaUtils() {
    }

    public static List<TSDataType> getAggregatedDataTypes(List<TSDataType> measurementDataType, String aggregation) {
        TSDataType dataType = SchemaUtils.getBuiltinAggregationTypeByFuncName(aggregation);
        if (dataType != null) {
            return Collections.nCopies(measurementDataType.size(), dataType);
        }
        return measurementDataType;
    }

    public static TSDataType getSeriesTypeByPath(TSDataType seriesType, String aggregation) {
        TSDataType dataType = SchemaUtils.getBuiltinAggregationTypeByFuncName(aggregation);
        if (dataType != null) {
            return dataType;
        }
        return seriesType;
    }

    public static TSDataType getBuiltinAggregationTypeByFuncName(String aggregation) {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": 
            case "time_duration": 
            case "count_time": {
                return TSDataType.INT64;
            }
            case "avg": 
            case "sum": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return TSDataType.DOUBLE;
            }
            case "stddev_partial": 
            case "stddev_pop_partial": 
            case "stddev_samp_partial": 
            case "variance_partial": 
            case "var_pop_partial": 
            case "var_samp_partial": 
            case "max_by_partial": 
            case "min_by_partial": {
                return TSDataType.TEXT;
            }
        }
        return null;
    }

    public static String getBuiltinAggregationName(TAggregationType aggregationType) {
        if (aggregationType == null) {
            return null;
        }
        switch (aggregationType) {
            case COUNT: {
                return "count";
            }
            case AVG: {
                return "avg";
            }
            case SUM: {
                return "sum";
            }
            case FIRST_VALUE: {
                return "first_value";
            }
            case LAST_VALUE: {
                return "last_value";
            }
            case MAX_TIME: {
                return "max_time";
            }
            case MIN_TIME: {
                return "min_time";
            }
            case MAX_VALUE: {
                return "max_value";
            }
            case MIN_VALUE: {
                return "min_value";
            }
            case EXTREME: {
                return "extreme";
            }
            case COUNT_IF: {
                return "count_if";
            }
            case TIME_DURATION: {
                return "time_duration";
            }
            case MODE: {
                return "mode";
            }
            case COUNT_TIME: {
                return "count_time";
            }
            case STDDEV: {
                return "stddev";
            }
            case STDDEV_POP: {
                return "stddev_pop";
            }
            case STDDEV_SAMP: {
                return "stddev_samp";
            }
            case VARIANCE: {
                return "variance";
            }
            case VAR_POP: {
                return "var_pop";
            }
            case VAR_SAMP: {
                return "var_samp";
            }
        }
        return null;
    }

    public static boolean isConsistentWithScanOrder(TAggregationType aggregationFunction, Ordering scanOrder) {
        boolean ascending = scanOrder == Ordering.ASC;
        switch (aggregationFunction) {
            case FIRST_VALUE: 
            case MIN_TIME: {
                return ascending;
            }
            case LAST_VALUE: 
            case MAX_TIME: {
                return !ascending;
            }
            case COUNT: 
            case AVG: 
            case SUM: 
            case MAX_VALUE: 
            case MIN_VALUE: 
            case EXTREME: 
            case TIME_DURATION: 
            case COUNT_TIME: 
            case STDDEV: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VARIANCE: 
            case VAR_POP: 
            case VAR_SAMP: 
            case MAX_BY: 
            case MIN_BY: 
            case UDAF: {
                return true;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationFunction));
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!encoding.isSupported(dataType)) {
            throw new MetadataException(String.format("encoding %s does not support %s", encoding, dataType), true);
        }
    }

    public static List<String> splitPartialBuiltinAggregation(TAggregationType aggregationType) {
        switch (aggregationType) {
            case FIRST_VALUE: {
                return Collections.singletonList("min_time");
            }
            case LAST_VALUE: {
                return Collections.singletonList("max_time");
            }
            case STDDEV: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"stddev"));
            }
            case STDDEV_POP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"stddev_pop"));
            }
            case STDDEV_SAMP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"stddev_samp"));
            }
            case VARIANCE: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"variance"));
            }
            case VAR_POP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"var_pop"));
            }
            case VAR_SAMP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"var_samp"));
            }
            case MAX_BY: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"max_by"));
            }
            case MIN_BY: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix((String)"min_by"));
            }
            case AVG: {
                return Arrays.asList("count", "sum");
            }
            case TIME_DURATION: {
                return Arrays.asList("max_time", "min_time");
            }
            case COUNT: 
            case SUM: 
            case MAX_TIME: 
            case MIN_TIME: 
            case MAX_VALUE: 
            case MIN_VALUE: 
            case EXTREME: 
            case COUNT_IF: 
            case MODE: 
            case COUNT_TIME: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationType));
    }
}

