/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.sink;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class IdentitySinkOperator
implements Operator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(IdentitySinkOperator.class) + RamUsageEstimator.shallowSizeOfInstance(DownStreamChannelIndex.class);
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final DownStreamChannelIndex downStreamChannelIndex;
    private final ISinkHandle sinkHandle;
    private boolean needToReturnNull = false;
    private boolean isFinished = false;

    public IdentitySinkOperator(OperatorContext operatorContext, List<Operator> children, DownStreamChannelIndex downStreamChannelIndex, ISinkHandle sinkHandle) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.downStreamChannelIndex = downStreamChannelIndex;
        this.sinkHandle = sinkHandle;
    }

    @Override
    public boolean hasNext() throws Exception {
        int currentIndex = this.downStreamChannelIndex.getCurrentIndex();
        boolean currentChannelClosed = this.sinkHandle.isChannelClosed(currentIndex);
        if (!currentChannelClosed && this.children.get(currentIndex).hasNextWithTimer()) {
            return true;
        }
        if (currentChannelClosed) {
            this.closeCurrentChild(currentIndex);
        } else {
            this.closeCurrentChild(currentIndex);
            this.sinkHandle.setNoMoreTsBlocksOfOneChannel(this.downStreamChannelIndex.getCurrentIndex());
        }
        if (++currentIndex >= this.children.size()) {
            this.isFinished = true;
            return false;
        }
        this.downStreamChannelIndex.setCurrentIndex(currentIndex);
        this.needToReturnNull = true;
        this.sinkHandle.tryOpenChannel(currentIndex);
        return true;
    }

    private void closeCurrentChild(int index) throws Exception {
        this.children.get(index).close();
        this.children.set(index, null);
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.needToReturnNull) {
            this.needToReturnNull = false;
            return null;
        }
        return this.children.get(this.downStreamChannelIndex.getCurrentIndex()).nextWithTimer();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.children.get(this.downStreamChannelIndex.getCurrentIndex()).isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.isFinished;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void close() throws Exception {
        int n = this.children.size();
        for (int i = this.downStreamChannelIndex.getCurrentIndex(); i < n; ++i) {
            Operator currentChild = this.children.get(i);
            if (currentChild == null) continue;
            currentChild.close();
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemoryWithCounter());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.children) {
            maxReturnSize = Math.max(maxReturnSize, child.calculateMaxReturnSize());
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @TestOnly
    public List<Operator> getChildren() {
        return this.children;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sinkHandle);
    }
}

