/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client.ainode;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.db.protocol.client.AINodeClientFactory;
import org.apache.iotdb.db.protocol.client.ainode.AINodeClient;

public class AINodeClientManager {
    public static final int DEFAULT_AINODE_ID = 0;
    private static final AINodeClientManager INSTANCE = new AINodeClientManager();
    private final IClientManager<TEndPoint, AINodeClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new AINodeClientFactory.AINodeClientPoolFactory());
    private volatile TEndPoint defaultAINodeEndPoint;

    private AINodeClientManager() {
    }

    public static AINodeClientManager getInstance() {
        return INSTANCE;
    }

    public void updateDefaultAINodeLocation(TEndPoint endPoint) {
        this.defaultAINodeEndPoint = endPoint;
    }

    public AINodeClient borrowClient(TEndPoint endPoint) throws Exception {
        return (AINodeClient)this.clientManager.borrowClient((Object)endPoint);
    }

    public AINodeClient borrowClient(int aiNodeId) throws Exception {
        if (aiNodeId != 0) {
            throw new IllegalArgumentException("Unsupported AINodeId: " + aiNodeId);
        }
        if (this.defaultAINodeEndPoint == null) {
            this.defaultAINodeEndPoint = AINodeClient.getCurrentEndpoint();
        }
        return (AINodeClient)this.clientManager.borrowClient((Object)this.defaultAINodeEndPoint);
    }

    public void clear(TEndPoint endPoint) {
        this.clientManager.clear((Object)endPoint);
    }

    public void clearAll() {
        this.clientManager.close();
    }

    public IClientManager<TEndPoint, AINodeClient> getRawClientManager() {
        return this.clientManager;
    }
}

