/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VirtualListViewResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String VIRTUAL_LIST_VIEW_RESPONSE_OID = "2.16.840.1.113730.3.4.10";
    @NotNull
    private static final String JSON_FIELD_CONTENT_COUNT = "content-count";
    @NotNull
    private static final String JSON_FIELD_CONTEXT_ID = "context-id";
    @NotNull
    private static final String JSON_FIELD_RESULT_CODE = "result-code";
    @NotNull
    private static final String JSON_FIELD_TARGET_POSITION = "target-position";
    private static final long serialVersionUID = -534656674756287217L;
    @Nullable
    private final ASN1OctetString contextID;
    private final int contentCount;
    @NotNull
    private final ResultCode resultCode;
    private final int targetPosition;

    VirtualListViewResponseControl() {
        this.targetPosition = -1;
        this.contentCount = -1;
        this.resultCode = null;
        this.contextID = null;
    }

    public VirtualListViewResponseControl(int targetPosition, int contentCount, @NotNull ResultCode resultCode, @Nullable ASN1OctetString contextID) {
        super(VIRTUAL_LIST_VIEW_RESPONSE_OID, false, VirtualListViewResponseControl.encodeValue(targetPosition, contentCount, resultCode, contextID));
        this.targetPosition = targetPosition;
        this.contentCount = contentCount;
        this.resultCode = resultCode;
        this.contextID = contextID;
    }

    public VirtualListViewResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] valueElements = valueSequence.elements();
        if (valueElements.length < 3 || valueElements.length > 4) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_INVALID_ELEMENT_COUNT.get(valueElements.length));
        }
        try {
            this.targetPosition = ASN1Integer.decodeAsInteger(valueElements[0]).intValue();
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_FIRST_NOT_INTEGER.get(ae), ae);
        }
        try {
            this.contentCount = ASN1Integer.decodeAsInteger(valueElements[1]).intValue();
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_SECOND_NOT_INTEGER.get(ae), ae);
        }
        try {
            int rc = ASN1Enumerated.decodeAsEnumerated(valueElements[2]).intValue();
            this.resultCode = ResultCode.valueOf(rc);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_THIRD_NOT_ENUM.get(ae), ae);
        }
        this.contextID = valueElements.length == 4 ? ASN1OctetString.decodeAsOctetString(valueElements[3]) : null;
    }

    @Override
    @NotNull
    public VirtualListViewResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new VirtualListViewResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static VirtualListViewResponseControl get(@NotNull SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(VIRTUAL_LIST_VIEW_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof VirtualListViewResponseControl) {
            return (VirtualListViewResponseControl)c;
        }
        return new VirtualListViewResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(int targetPosition, int contentCount, @NotNull ResultCode resultCode, @Nullable ASN1OctetString contextID) {
        ASN1Element[] vlvElements = contextID == null ? new ASN1Element[]{new ASN1Integer(targetPosition), new ASN1Integer(contentCount), new ASN1Enumerated(resultCode.intValue())} : new ASN1Element[]{new ASN1Integer(targetPosition), new ASN1Integer(contentCount), new ASN1Enumerated(resultCode.intValue()), contextID};
        return new ASN1OctetString(new ASN1Sequence(vlvElements).encode());
    }

    public int getTargetPosition() {
        return this.targetPosition;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    @NotNull
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public ASN1OctetString getContextID() {
        return this.contextID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_VLV_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_RESULT_CODE, new JSONNumber(this.resultCode.intValue()));
        valueFields.put(JSON_FIELD_TARGET_POSITION, new JSONNumber(this.targetPosition));
        valueFields.put(JSON_FIELD_CONTENT_COUNT, new JSONNumber(this.contentCount));
        if (this.contextID != null) {
            valueFields.put(JSON_FIELD_CONTEXT_ID, new JSONString(Base64.encode(this.contextID.getValue())));
        }
        return new JSONObject(new JSONField("oid", VIRTUAL_LIST_VIEW_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_VLV_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static VirtualListViewResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ASN1OctetString contextID;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new VirtualListViewResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Integer resultCodeInt = valueObject.getFieldAsInteger(JSON_FIELD_RESULT_CODE);
        if (resultCodeInt == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_RESULT_CODE));
        }
        ResultCode resultCode = ResultCode.valueOf(resultCodeInt);
        Integer targetPosition = valueObject.getFieldAsInteger(JSON_FIELD_TARGET_POSITION);
        if (targetPosition == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_TARGET_POSITION));
        }
        Integer contentCount = valueObject.getFieldAsInteger(JSON_FIELD_CONTENT_COUNT);
        if (contentCount == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_CONTENT_COUNT));
        }
        String contextIDBase64 = valueObject.getFieldAsString(JSON_FIELD_CONTEXT_ID);
        if (contextIDBase64 == null) {
            contextID = null;
        } else {
            try {
                contextID = new ASN1OctetString(Base64.decode(contextIDBase64));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_JSON_CONTEXT_ID_NOT_BASE64.get(controlObject.toSingleLineString(), JSON_FIELD_CONTEXT_ID), e);
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_RESULT_CODE, JSON_FIELD_TARGET_POSITION, JSON_FIELD_CONTENT_COUNT, JSON_FIELD_CONTEXT_ID)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_VLV_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new VirtualListViewResponseControl(targetPosition, contentCount, resultCode, contextID);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("VirtualListViewResponseControl(targetPosition=");
        buffer.append(this.targetPosition);
        buffer.append(", contentCount=");
        buffer.append(this.contentCount);
        buffer.append(", resultCode=");
        buffer.append(this.resultCode);
        buffer.append(')');
    }
}

