/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class TextFormattedAssuranceCompletedAccessLogMessageHelper
implements Serializable {
    private static final long serialVersionUID = -1660878235825975297L;
    @Nullable
    private final Boolean localAssuranceSatisfied;
    @Nullable
    private final Boolean remoteAssuranceSatisfied;
    @NotNull
    private final List<String> serverResults;

    TextFormattedAssuranceCompletedAccessLogMessageHelper(@NotNull TextFormattedRequestAccessLogMessage logMessage) {
        this.localAssuranceSatisfied = logMessage.getBooleanNoThrow(TextFormattedAccessLogFields.LOCAL_ASSURANCE_SATISFIED);
        this.remoteAssuranceSatisfied = logMessage.getBooleanNoThrow(TextFormattedAccessLogFields.REMOTE_ASSURANCE_SATISFIED);
        this.serverResults = logMessage.getCommaDelimitedStringList(TextFormattedAccessLogFields.SERVER_ASSURANCE_RESULTS);
    }

    @Nullable
    Boolean getLocalAssuranceSatisfied() {
        return this.localAssuranceSatisfied;
    }

    @Nullable
    Boolean getRemoteAssuranceSatisfied() {
        return this.remoteAssuranceSatisfied;
    }

    @NotNull
    List<String> getServerResults() {
        return this.serverResults;
    }
}

