/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.schema;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public interface KeyspaceReplicationOptions<TargetT> {
    @NonNull
    default public TargetT withSimpleStrategy(int replicationFactor) {
        ImmutableMap replication = ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)replicationFactor).build();
        return this.withReplicationOptions((Map<String, Object>)replication);
    }

    @NonNull
    default public TargetT withNetworkTopologyStrategy(@NonNull Map<String, Integer> replications) {
        ImmutableMap.Builder replicationBuilder = ImmutableMap.builder().put((Object)"class", (Object)"NetworkTopologyStrategy");
        for (Map.Entry<String, Integer> replication : replications.entrySet()) {
            replicationBuilder.put((Object)replication.getKey(), (Object)replication.getValue());
        }
        return this.withReplicationOptions((Map<String, Object>)replicationBuilder.build());
    }

    @NonNull
    public TargetT withReplicationOptions(@NonNull Map<String, Object> var1);
}

