/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.james.jmap.exceptions.NoAuthorizationSuppliedException;
import org.apache.james.jmap.http.AuthenticateHeader;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class Authenticator {
    private final List<AuthenticationStrategy> authMethods;
    private final MetricFactory metricFactory;

    public static Authenticator of(MetricFactory metricFactory, AuthenticationStrategy ... authenticationStrategies) {
        return Authenticator.of(metricFactory, (Collection<AuthenticationStrategy>)ImmutableList.copyOf((Object[])authenticationStrategies));
    }

    public static Authenticator of(MetricFactory metricFactory, Collection<AuthenticationStrategy> authenticationStrategies) {
        return new Authenticator((List<AuthenticationStrategy>)ImmutableList.copyOf(authenticationStrategies), metricFactory);
    }

    @VisibleForTesting
    Authenticator(List<AuthenticationStrategy> authMethods, MetricFactory metricFactory) {
        this.authMethods = authMethods;
        this.metricFactory = metricFactory;
    }

    public Mono<MailboxSession> authenticate(HttpServerRequest request) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-authentication-filter", (Publisher)Flux.fromIterable(this.authMethods).concatMap(auth -> auth.createMailboxSession(request)).next().switchIfEmpty(Mono.error(this::noAuthSupplied))));
    }

    private NoAuthorizationSuppliedException noAuthSupplied() {
        return new NoAuthorizationSuppliedException(AuthenticateHeader.of((Collection)this.authMethods.stream().map(AuthenticationStrategy::correspondingChallenge).collect(ImmutableList.toImmutableList())));
    }
}

