/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class VaultConfiguration {
    public static final VaultConfiguration DEFAULT = new VaultConfiguration(false, ChronoUnit.YEARS.getDuration(), "Restored-Messages");
    public static final VaultConfiguration ENABLED_DEFAULT = new VaultConfiguration(true, ChronoUnit.YEARS.getDuration(), "Restored-Messages");
    private final boolean enabled;
    private final Duration retentionPeriod;
    private final String restoreLocation;

    public static VaultConfiguration from(Configuration propertiesConfiguration) {
        Duration retentionPeriod = Optional.ofNullable(propertiesConfiguration.getString("retentionPeriod")).map(string -> DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.DAYS)).orElse(DEFAULT.getRetentionPeriod());
        String restoreLocation = Optional.ofNullable(propertiesConfiguration.getString("restoreLocation")).orElse(DEFAULT.getRestoreLocation());
        boolean enabled = propertiesConfiguration.getBoolean("enabled", false);
        return new VaultConfiguration(enabled, retentionPeriod, restoreLocation);
    }

    VaultConfiguration(boolean enabled, Duration retentionPeriod, String restoreLocation) {
        this.enabled = enabled;
        Preconditions.checkNotNull((Object)retentionPeriod);
        Preconditions.checkNotNull((Object)restoreLocation);
        this.retentionPeriod = retentionPeriod;
        this.restoreLocation = restoreLocation;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public String getRestoreLocation() {
        return this.restoreLocation;
    }

    public final boolean equals(Object o) {
        if (o instanceof VaultConfiguration) {
            VaultConfiguration that = (VaultConfiguration)o;
            return Objects.equals(this.retentionPeriod, that.retentionPeriod) && Objects.equals(this.restoreLocation, that.restoreLocation) && Objects.equals(this.enabled, that.enabled);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.retentionPeriod, this.restoreLocation, this.enabled);
    }
}

