/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobPartsId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobType;

public class MimeMessagePartsId
implements BlobPartsId {
    static final BlobType HEADER_BLOB_TYPE = new BlobType("mailHeader", BlobStore.StoragePolicy.SIZE_BASED);
    static final BlobType BODY_BLOB_TYPE = new BlobType("mailBody", BlobStore.StoragePolicy.LOW_COST);
    private final BlobId headerBlobId;
    private final BlobId bodyBlobId;

    public static RequireHeaderBlobId builder() {
        return headerBlobId -> bodyBlobId -> new Builder(headerBlobId, bodyBlobId);
    }

    private MimeMessagePartsId(BlobId headerBlobId, BlobId bodyBlobId) {
        this.headerBlobId = headerBlobId;
        this.bodyBlobId = bodyBlobId;
    }

    public Map<BlobType, BlobId> asMap() {
        return ImmutableMap.of((Object)HEADER_BLOB_TYPE, (Object)this.headerBlobId, (Object)BODY_BLOB_TYPE, (Object)this.bodyBlobId);
    }

    public BlobId getHeaderBlobId() {
        return this.headerBlobId;
    }

    public BlobId getBodyBlobId() {
        return this.bodyBlobId;
    }

    public final boolean equals(Object o) {
        if (o instanceof MimeMessagePartsId) {
            MimeMessagePartsId that = (MimeMessagePartsId)o;
            return Objects.equals(this.headerBlobId, that.headerBlobId) && Objects.equals(this.bodyBlobId, that.bodyBlobId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.headerBlobId, this.bodyBlobId);
    }

    public static class Factory
    implements BlobPartsId.Factory<MimeMessagePartsId> {
        public MimeMessagePartsId generate(Map<BlobType, BlobId> map) {
            Preconditions.checkArgument((boolean)map.containsKey(HEADER_BLOB_TYPE), (Object)"Expecting 'mailHeader' blobId to be specified");
            Preconditions.checkArgument((boolean)map.containsKey(BODY_BLOB_TYPE), (Object)"Expecting 'mailBody' blobId to be specified");
            Preconditions.checkArgument((map.size() == 2 ? 1 : 0) != 0, (Object)"blobId other than 'mailHeader' or 'mailBody' are not supported");
            return MimeMessagePartsId.builder().headerBlobId(map.get(HEADER_BLOB_TYPE)).bodyBlobId(map.get(BODY_BLOB_TYPE)).build();
        }
    }

    public static class Builder {
        private final BlobId headerBlobId;
        private final BlobId bodyBlobId;

        private Builder(BlobId headerBlobId, BlobId bodyBlobId) {
            Preconditions.checkNotNull((Object)headerBlobId, (Object)"'headerBlobId' should not be null");
            Preconditions.checkNotNull((Object)bodyBlobId, (Object)"'bodyBlobId' should not be null");
            this.headerBlobId = headerBlobId;
            this.bodyBlobId = bodyBlobId;
        }

        public MimeMessagePartsId build() {
            return new MimeMessagePartsId(this.headerBlobId, this.bodyBlobId);
        }
    }

    @FunctionalInterface
    public static interface RequireBodyBlobId {
        public Builder bodyBlobId(BlobId var1);
    }

    @FunctionalInterface
    public static interface RequireHeaderBlobId {
        public RequireBodyBlobId headerBlobId(BlobId var1);
    }
}

