/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Limit$;
import org.apache.james.jmap.core.Position$;
import org.apache.james.jmap.core.QueryState$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.json.MailboxQuerySerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.MailboxQueryRequest;
import org.apache.james.jmap.mail.MailboxQueryResponse;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\t\u0012\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011)\u0019!C\u0001k!Aa\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0011!9\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\t\u0011A\u0003!\u0011!Q\u0001\n)CQ!\u0015\u0001\u0005\u0002ICq!\u0019\u0001C\u0002\u0013\u0005#\r\u0003\u0004x\u0001\u0001\u0006Ia\u0019\u0005\bq\u0002\u0011\r\u0011\"\u0011z\u0011\u001d\t\u0019\u0002\u0001Q\u0001\niDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\t\u0011R*Y5mE>D\u0018+^3ss6+G\u000f[8e\u0015\t\u00112#\u0001\u0004nKRDw\u000e\u001a\u0006\u0003)U\tAA[7ba*\u0011acF\u0001\u0006U\u0006lWm\u001d\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0004I\u0015:S\"A\t\n\u0005\u0019\n\"\u0001G'fi\"|GMU3rk&\u0014\u0018N\\4BG\u000e|WO\u001c;JIB\u0011\u0001fK\u0007\u0002S)\u0011!fE\u0001\u0005[\u0006LG.\u0003\u0002-S\t\u0019R*Y5mE>D\u0018+^3ssJ+\u0017/^3ti\u000692/_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM\u001d\t\u0003_Ij\u0011\u0001\r\u0006\u0003cU\tq!\\1jY\n|\u00070\u0003\u00024a\t92+_:uK6l\u0015-\u001b7c_b,7\u000f\u0015:pm&$WM]\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u0007\u0005\u0004\u0018N\u0003\u0002<+\u00059Q.\u001a;sS\u000e\u001c\u0018BA\u001f9\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013aD:fgNLwN\\*vaBd\u0017.\u001a:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001R\n\u0002\rI|W\u000f^3t\u0013\t15IA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b%A\ttKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\tAaY8sK&\u0011q\n\u0014\u0002\u0012'\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\u0018AE:fgNLwN\u001c+sC:\u001cH.\u0019;pe\u0002\na\u0001P5oSRtD#B*U+Z;\u0006C\u0001\u0013\u0001\u0011\u0015i\u0003\u00021\u0001/\u0011\u0015!\u0004\u00021\u00017\u0011\u0015y\u0004\u00021\u0001B\u0011\u0015A\u0005\u00021\u0001KQ\tA\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u00061\u0011N\u001c6fGRT\u0011AX\u0001\u0006U\u00064\u0018\r_\u0005\u0003An\u0013a!\u00138kK\u000e$\u0018AC7fi\"|GMT1nKV\t1\r\u0005\u0002ei:\u0011QM\u001d\b\u0003MFt!a\u001a9\u000f\u0005!|gBA5o\u001d\tQW.D\u0001l\u0015\ta7$\u0001\u0004=e>|GOP\u0005\u00025%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u00055\u001b\u0012BA:M\u0003)IeN^8dCRLwN\\\u0005\u0003kZ\u0014!\"T3uQ>$g*Y7f\u0015\t\u0019H*A\u0006nKRDw\u000e\u001a(b[\u0016\u0004\u0013\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7/F\u0001{!\u0011Yx0!\u0002\u000f\u0005ql\bC\u00016 \u0013\tqx$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019AA\u0002TKRT!A`\u0010\u0011\t\u0005\u001d\u0011Q\u0002\b\u0004K\u0006%\u0011bAA\u0006\u0019\u0006!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJLA!a\u0004\u0002\u0012\t!2)\u00199bE&d\u0017\u000e^=JI\u0016tG/\u001b4jKJT1!a\u0003M\u0003U\u0011X-];je\u0016$7)\u00199bE&d\u0017\u000e^5fg\u0002\n\u0011\u0002Z8Qe>\u001cWm]:\u0015\u0015\u0005e\u00111GA\u001c\u0003w\t)\u0005\u0005\u0004\u0002\u001c\u0005%\u0012QF\u0007\u0003\u0003;QA!a\b\u0002\"\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0004A\u0005\r\"bA'\u0002&)\u0011\u0011qE\u0001\be\u0016\f7\r^8s\u0013\u0011\tY#!\b\u0003\u000bMkuN\\8\u0011\u0007\u0011\ny#C\u0002\u00022E\u0011Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000f\u0003\u0004\u000265\u0001\rA_\u0001\rG\u0006\u0004\u0018MY5mSRLWm\u001d\u0005\b\u0003si\u0001\u0019AA\u0017\u0003)IgN^8dCRLwN\u001c\u0005\b\u0003{i\u0001\u0019AA \u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u00042aLA!\u0013\r\t\u0019\u0005\r\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0011\u0019\t9%\u0004a\u0001O\u00059!/Z9vKN$\u0018AC4fiJ+\u0017/^3tiR1\u0011QJA3\u0003O\u0002r!a\u0014\u0002Z\u0005}sE\u0004\u0003\u0002R\u0005Ucb\u00016\u0002T%\t\u0001%C\u0002\u0002X}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\\\u0005u#AB#ji\",'OC\u0002\u0002X}\u0001B!a\u0014\u0002b%!\u00111MA/\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0005\b\u0003{q\u0001\u0019AA \u0011\u001d\tID\u0004a\u0001\u0003S\u00022aSA6\u0013\r\ti\u0007\u0014\u0002\u000b\u0013:4xnY1uS>t\u0017A\u00049s_\u000e,7o\u001d*fcV,7\u000f\u001e\u000b\t\u0003g\n)(a\u001e\u0002zA1\u00111DA\u0015\u0003SBq!!\u0010\u0010\u0001\u0004\ty\u0004C\u0004\u0002:=\u0001\r!!\u001b\t\r\u0005\u001ds\u00021\u0001(\u0001")
public class MailboxQueryMethod
implements MethodRequiringAccountId<MailboxQueryRequest> {
    private final SystemMailboxesProvider systemMailboxesProvider;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MailboxQueryRequest request) {
        return this.processRequest(mailboxSession, invocation.invocation(), request).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, MailboxQueryRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return MailboxQuerySerializer$.MODULE$.deserialize((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> ResponseSerializer$.MODULE$.asException((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
    }

    private SMono<Invocation> processRequest(MailboxSession mailboxSession, Invocation invocation, MailboxQueryRequest request) {
        return SFlux$.MODULE$.fromPublisher(this.systemMailboxesProvider.getMailboxByRole(request.filter().role(), mailboxSession.getUser())).map((Function1 & Serializable)x$1 -> x$1.getId()).collectSeq().map((Function1 & Serializable)ids -> new MailboxQueryResponse(request.accountId(), QueryState$.MODULE$.forMailboxIds((scala.collection.immutable.Seq<MailboxId>)ids), false, (scala.collection.immutable.Seq)ids, Position$.MODULE$.zero(), (Option)new Some((Object)new Refined((Object)Limit$.MODULE$.default())))).map((Function1 & Serializable)response -> new Invocation(this.methodName(), MailboxQuerySerializer$.MODULE$.serialize((MailboxQueryResponse)response), invocation.methodCallId()));
    }

    @Inject
    public MailboxQueryMethod(SystemMailboxesProvider systemMailboxesProvider, MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator) {
        this.systemMailboxesProvider = systemMailboxesProvider;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Mailbox/query")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

