/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.hybrid.internal.HpkeKemPrivateKey;
import com.google.crypto.tink.hybrid.internal.NistCurvesHpkeKemPrivateKey;
import com.google.crypto.tink.hybrid.internal.X25519HpkeKemPrivateKey;
import com.google.crypto.tink.proto.HpkeKem;
import com.google.crypto.tink.proto.HpkePrivateKey;
import com.google.crypto.tink.subtle.EllipticCurves;
import java.security.GeneralSecurityException;

final class HpkeKemKeyFactory {
    private static EllipticCurves.CurveType nistHpkeKemToCurve(HpkeKem kem) throws GeneralSecurityException {
        switch (kem) {
            case DHKEM_P256_HKDF_SHA256: {
                return EllipticCurves.CurveType.NIST_P256;
            }
            case DHKEM_P384_HKDF_SHA384: {
                return EllipticCurves.CurveType.NIST_P384;
            }
            case DHKEM_P521_HKDF_SHA512: {
                return EllipticCurves.CurveType.NIST_P521;
            }
        }
        throw new GeneralSecurityException("Unrecognized NIST HPKE KEM identifier");
    }

    static HpkeKemPrivateKey createPrivate(HpkePrivateKey privateKey) throws GeneralSecurityException {
        switch (privateKey.getPublicKey().getParams().getKem()) {
            case DHKEM_X25519_HKDF_SHA256: {
                return X25519HpkeKemPrivateKey.fromBytes(privateKey.getPrivateKey().toByteArray());
            }
            case DHKEM_P256_HKDF_SHA256: 
            case DHKEM_P384_HKDF_SHA384: 
            case DHKEM_P521_HKDF_SHA512: {
                return NistCurvesHpkeKemPrivateKey.fromBytes(privateKey.getPrivateKey().toByteArray(), privateKey.getPublicKey().getPublicKey().toByteArray(), HpkeKemKeyFactory.nistHpkeKemToCurve(privateKey.getPublicKey().getParams().getKem()));
            }
        }
        throw new GeneralSecurityException("Unrecognized HPKE KEM identifier");
    }

    private HpkeKemKeyFactory() {
    }
}

