/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.task.Task;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SolveMessageInconsistenciesService {
    private static final Inconsistency NO_INCONSISTENCY = (context, imapUidDAO, messageIdDAO) -> Mono.just((Object)Task.Result.COMPLETED);
    private static final Logger LOGGER = LoggerFactory.getLogger(SolveMessageInconsistenciesService.class);
    private static final Duration PERIOD = Duration.ofSeconds(1L);
    private final CassandraMessageIdToImapUidDAO messageIdToImapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;

    @Inject
    SolveMessageInconsistenciesService(CassandraMessageIdToImapUidDAO messageIdToImapUidDAO, CassandraMessageIdDAO messageIdDAO) {
        this.messageIdToImapUidDAO = messageIdToImapUidDAO;
        this.messageIdDAO = messageIdDAO;
    }

    public Mono<Task.Result> fixMessageInconsistencies(Context context, RunningOptions runningOptions) {
        return Flux.concat((Publisher[])new Publisher[]{this.fixInconsistenciesInMessageId(context, runningOptions), this.fixInconsistenciesInImapUid(context, runningOptions)}).reduce((Object)Task.Result.COMPLETED, Task::combine);
    }

    private Flux<Task.Result> fixInconsistenciesInImapUid(Context context, RunningOptions runningOptions) {
        return this.messageIdToImapUidDAO.retrieveAllMessages().transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(metaData -> this.detectInconsistencyInImapUid((CassandraMessageMetadata)metaData).doOnNext(any -> context.incrementProcessedImapUidEntries()).flatMap(inconsistency -> inconsistency.fix(context, this.messageIdToImapUidDAO, this.messageIdDAO))));
    }

    private Mono<Inconsistency> detectInconsistencyInImapUid(CassandraMessageMetadata message) {
        return this.compareWithMessageIdRecord(message).onErrorResume(error -> Mono.just((Object)new FailedToRetrieveRecord(message)));
    }

    private Mono<Inconsistency> compareWithMessageIdRecord(CassandraMessageMetadata messageFromImapUid) {
        ComposedMessageId ids = messageFromImapUid.getComposedMessageId().getComposedMessageId();
        CassandraId mailboxId = (CassandraId)ids.getMailboxId();
        MessageUid uid = ids.getUid();
        CassandraMessageId messageId = (CassandraMessageId)ids.getMessageId();
        return this.messageIdDAO.retrieve(mailboxId, uid).handle(ReactorUtils.publishIfPresent()).flatMap(messageIdRecord -> {
            if (messageIdRecord.equals(messageFromImapUid)) {
                return Mono.just((Object)NO_INCONSISTENCY);
            }
            return this.detectOutdatedMessageIdEntry(mailboxId, messageId, (CassandraMessageMetadata)messageIdRecord);
        }).switchIfEmpty(this.detectOrphanImapUidEntry(mailboxId, messageId));
    }

    private Mono<Inconsistency> detectOutdatedMessageIdEntry(CassandraId mailboxId, CassandraMessageId messageId, CassandraMessageMetadata messageIdRecord) {
        return this.messageIdToImapUidDAO.retrieve(messageId, Optional.of(mailboxId), JamesExecutionProfiles.ConsistencyChoice.STRONG).filter(Predicate.not(Predicate.isEqual(messageIdRecord))).map(upToDateMessageFromImapUid -> new OutdatedMessageIdEntry(messageIdRecord, (CassandraMessageMetadata)upToDateMessageFromImapUid)).next().switchIfEmpty(Mono.just((Object)NO_INCONSISTENCY));
    }

    private Mono<Inconsistency> detectOrphanImapUidEntry(CassandraId mailboxId, CassandraMessageId messageId) {
        return this.messageIdToImapUidDAO.retrieve(messageId, Optional.of(mailboxId), JamesExecutionProfiles.ConsistencyChoice.STRONG).next().map(x$0 -> new OrphanImapUidEntry((CassandraMessageMetadata)x$0)).switchIfEmpty(Mono.just((Object)NO_INCONSISTENCY));
    }

    private Flux<Task.Result> fixInconsistenciesInMessageId(Context context, RunningOptions runningOptions) {
        return this.messageIdDAO.retrieveAllMessages().transform(ReactorUtils.throttle().elements(runningOptions.getMessagesPerSecond()).per(PERIOD).forOperation(metadata -> this.detectInconsistencyInMessageId((CassandraMessageMetadata)metadata).doOnNext(any -> context.incrementMessageIdEntries()).flatMap(inconsistency -> inconsistency.fix(context, this.messageIdToImapUidDAO, this.messageIdDAO))));
    }

    private Mono<Inconsistency> detectInconsistencyInMessageId(CassandraMessageMetadata message) {
        return this.messageIdToImapUidDAO.retrieve((CassandraMessageId)message.getComposedMessageId().getComposedMessageId().getMessageId(), Optional.of((CassandraId)message.getComposedMessageId().getComposedMessageId().getMailboxId()), JamesExecutionProfiles.ConsistencyChoice.STRONG).map(uidRecord -> NO_INCONSISTENCY).next().switchIfEmpty(this.detectOrphanMessageIdEntry(message)).onErrorResume(error -> Mono.just((Object)new FailedToRetrieveRecord(message)));
    }

    private Mono<Inconsistency> detectOrphanMessageIdEntry(CassandraMessageMetadata message) {
        return this.messageIdDAO.retrieve((CassandraId)message.getComposedMessageId().getComposedMessageId().getMailboxId(), message.getComposedMessageId().getComposedMessageId().getUid()).handle(ReactorUtils.publishIfPresent()).map(x$0 -> new OrphanMessageIdEntry((CassandraMessageMetadata)x$0)).switchIfEmpty(Mono.just((Object)NO_INCONSISTENCY));
    }

    public static class Context {
        private final AtomicLong processedImapUidEntries;
        private final AtomicLong processedMessageIdEntries;
        private final AtomicLong addedMessageIdEntries;
        private final AtomicLong updatedMessageIdEntries;
        private final AtomicLong removedMessageIdEntries;
        private final ConcurrentLinkedDeque<ComposedMessageId> fixedInconsistencies;
        private final ConcurrentLinkedDeque<ComposedMessageId> errors;

        Context() {
            this(new AtomicLong(), new AtomicLong(), new AtomicLong(), new AtomicLong(), new AtomicLong(), (Collection<ComposedMessageId>)ImmutableList.of(), (Collection<ComposedMessageId>)ImmutableList.of());
        }

        private Context(AtomicLong processedImapUidEntries, AtomicLong processedMessageIdEntries, AtomicLong addedMessageIdEntries, AtomicLong updatedMessageIdEntries, AtomicLong removedMessageIdEntries, Collection<ComposedMessageId> fixedInconsistencies, Collection<ComposedMessageId> errors) {
            this.processedImapUidEntries = processedImapUidEntries;
            this.processedMessageIdEntries = processedMessageIdEntries;
            this.addedMessageIdEntries = addedMessageIdEntries;
            this.updatedMessageIdEntries = updatedMessageIdEntries;
            this.removedMessageIdEntries = removedMessageIdEntries;
            this.fixedInconsistencies = new ConcurrentLinkedDeque<ComposedMessageId>(fixedInconsistencies);
            this.errors = new ConcurrentLinkedDeque<ComposedMessageId>(errors);
        }

        void incrementProcessedImapUidEntries() {
            this.processedImapUidEntries.incrementAndGet();
        }

        void incrementMessageIdEntries() {
            this.processedMessageIdEntries.incrementAndGet();
        }

        void incrementAddedMessageIdEntries() {
            this.addedMessageIdEntries.incrementAndGet();
        }

        void incrementUpdatedMessageIdEntries() {
            this.updatedMessageIdEntries.incrementAndGet();
        }

        void incrementRemovedMessageIdEntries() {
            this.removedMessageIdEntries.incrementAndGet();
        }

        void addFixedInconsistency(ComposedMessageId messageId) {
            this.fixedInconsistencies.add(messageId);
        }

        void addErrors(ComposedMessageId messageId) {
            this.errors.add(messageId);
        }

        Snapshot snapshot() {
            return new Snapshot(this.processedImapUidEntries.get(), this.processedMessageIdEntries.get(), this.addedMessageIdEntries.get(), this.updatedMessageIdEntries.get(), this.removedMessageIdEntries.get(), (ImmutableList<ComposedMessageId>)ImmutableList.copyOf(this.fixedInconsistencies), (ImmutableList<ComposedMessageId>)ImmutableList.copyOf(this.errors));
        }

        static class Snapshot {
            private final long processedImapUidEntries;
            private final long processedMessageIdEntries;
            private final long addedMessageIdEntries;
            private final long updatedMessageIdEntries;
            private final long removedMessageIdEntries;
            private final ImmutableList<ComposedMessageId> fixedInconsistencies;
            private final ImmutableList<ComposedMessageId> errors;

            public static Builder builder() {
                return new Builder();
            }

            private Snapshot(long processedImapUidEntries, long processedMessageIdEntries, long addedMessageIdEntries, long updatedMessageIdEntries, long removedMessageIdEntries, ImmutableList<ComposedMessageId> fixedInconsistencies, ImmutableList<ComposedMessageId> errors) {
                this.processedImapUidEntries = processedImapUidEntries;
                this.processedMessageIdEntries = processedMessageIdEntries;
                this.addedMessageIdEntries = addedMessageIdEntries;
                this.updatedMessageIdEntries = updatedMessageIdEntries;
                this.removedMessageIdEntries = removedMessageIdEntries;
                this.fixedInconsistencies = fixedInconsistencies;
                this.errors = errors;
            }

            public long getProcessedImapUidEntries() {
                return this.processedImapUidEntries;
            }

            public long getProcessedMessageIdEntries() {
                return this.processedMessageIdEntries;
            }

            public long getAddedMessageIdEntries() {
                return this.addedMessageIdEntries;
            }

            public long getUpdatedMessageIdEntries() {
                return this.updatedMessageIdEntries;
            }

            public long getRemovedMessageIdEntries() {
                return this.removedMessageIdEntries;
            }

            public ImmutableList<ComposedMessageId> getFixedInconsistencies() {
                return this.fixedInconsistencies;
            }

            public ImmutableList<ComposedMessageId> getErrors() {
                return this.errors;
            }

            public final boolean equals(Object o) {
                if (o instanceof Snapshot) {
                    Snapshot snapshot = (Snapshot)o;
                    return Objects.equals(this.processedImapUidEntries, snapshot.processedImapUidEntries) && Objects.equals(this.processedMessageIdEntries, snapshot.processedMessageIdEntries) && Objects.equals(this.addedMessageIdEntries, snapshot.addedMessageIdEntries) && Objects.equals(this.updatedMessageIdEntries, snapshot.updatedMessageIdEntries) && Objects.equals(this.removedMessageIdEntries, snapshot.removedMessageIdEntries) && Objects.equals(this.errors, snapshot.errors) && Objects.equals(this.fixedInconsistencies, snapshot.fixedInconsistencies);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.processedImapUidEntries, this.processedMessageIdEntries, this.addedMessageIdEntries, this.updatedMessageIdEntries, this.removedMessageIdEntries, this.fixedInconsistencies, this.errors);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("processedImapUidEntries", this.processedImapUidEntries).add("processedMessageIdEntries", this.processedMessageIdEntries).add("addedMessageIdEntries", this.addedMessageIdEntries).add("updatedMessageIdEntries", this.updatedMessageIdEntries).add("removedMessageIdEntries", this.removedMessageIdEntries).add("fixedInconsistencies", this.fixedInconsistencies).add("errors", this.errors).toString();
            }

            static class Builder {
                private Optional<Long> processedImapUidEntries = Optional.empty();
                private Optional<Long> processedMessageIdEntries = Optional.empty();
                private Optional<Long> addedMessageIdEntries = Optional.empty();
                private Optional<Long> updatedMessageIdEntries = Optional.empty();
                private Optional<Long> removedMessageIdEntries = Optional.empty();
                private ImmutableList.Builder<ComposedMessageId> fixedInconsistencies = ImmutableList.builder();
                private ImmutableList.Builder<ComposedMessageId> errors = ImmutableList.builder();

                Builder() {
                }

                public Builder processedImapUidEntries(long count) {
                    this.processedImapUidEntries = Optional.of(count);
                    return this;
                }

                public Builder processedMessageIdEntries(long count) {
                    this.processedMessageIdEntries = Optional.of(count);
                    return this;
                }

                public Builder addedMessageIdEntries(long count) {
                    this.addedMessageIdEntries = Optional.of(count);
                    return this;
                }

                public Builder updatedMessageIdEntries(long count) {
                    this.updatedMessageIdEntries = Optional.of(count);
                    return this;
                }

                public Builder removedMessageIdEntries(long count) {
                    this.removedMessageIdEntries = Optional.of(count);
                    return this;
                }

                public Builder addFixedInconsistencies(ComposedMessageId composedMessageId) {
                    this.fixedInconsistencies.add((Object)composedMessageId);
                    return this;
                }

                public Builder errors(ComposedMessageId composedMessageId) {
                    this.errors.add((Object)composedMessageId);
                    return this;
                }

                public Snapshot build() {
                    return new Snapshot(this.processedImapUidEntries.orElse(0L), this.processedMessageIdEntries.orElse(0L), this.addedMessageIdEntries.orElse(0L), this.updatedMessageIdEntries.orElse(0L), this.removedMessageIdEntries.orElse(0L), (ImmutableList<ComposedMessageId>)this.fixedInconsistencies.build(), (ImmutableList<ComposedMessageId>)this.errors.build());
                }
            }
        }
    }

    public static class RunningOptions {
        public static final RunningOptions DEFAULT = new RunningOptions(100);
        private final int messagesPerSecond;

        public RunningOptions(int messagesPerSecond) {
            Preconditions.checkArgument((messagesPerSecond > 0 ? 1 : 0) != 0, (Object)"'messagesPerSecond' must be strictly positive");
            this.messagesPerSecond = messagesPerSecond;
        }

        public int getMessagesPerSecond() {
            return this.messagesPerSecond;
        }
    }

    private static class OrphanMessageIdEntry
    implements Inconsistency {
        private final CassandraMessageMetadata message;

        private OrphanMessageIdEntry(CassandraMessageMetadata message) {
            this.message = message;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO) {
            return messageIdDAO.delete((CassandraId)this.message.getComposedMessageId().getComposedMessageId().getMailboxId(), this.message.getComposedMessageId().getComposedMessageId().getUid()).doOnSuccess(any -> this.notifySuccess(context)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                this.notifyFailure(context);
                return Mono.just((Object)Task.Result.PARTIAL);
            });
        }

        private void notifyFailure(Context context) {
            context.addErrors(this.message.getComposedMessageId().getComposedMessageId());
            LOGGER.error("Failed to fix inconsistency for orphan message in MessageId: {}", (Object)this.message.getComposedMessageId());
        }

        private void notifySuccess(Context context) {
            LOGGER.info("Inconsistency fixed for orphan message in MessageId: {}", (Object)this.message.getComposedMessageId());
            context.incrementRemovedMessageIdEntries();
            context.addFixedInconsistency(this.message.getComposedMessageId().getComposedMessageId());
        }
    }

    private static class OutdatedMessageIdEntry
    implements Inconsistency {
        private final CassandraMessageMetadata messageFromMessageId;
        private final CassandraMessageMetadata messageFromImapUid;

        private OutdatedMessageIdEntry(CassandraMessageMetadata message, CassandraMessageMetadata messageFromImapUid) {
            this.messageFromMessageId = message;
            this.messageFromImapUid = messageFromImapUid;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO) {
            ComposedMessageIdWithMetaData id = this.messageFromImapUid.getComposedMessageId();
            return messageIdDAO.updateMetadata(id.getComposedMessageId(), UpdatedFlags.builder().oldFlags(new Flags()).newFlags(id.getFlags()).modSeq(id.getModSeq()).messageId(id.getComposedMessageId().getMessageId()).uid(id.getComposedMessageId().getUid()).build()).doOnSuccess(any -> this.notifySuccess(context)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                this.notifyFailure(context);
                return Mono.just((Object)Task.Result.PARTIAL);
            });
        }

        private void notifyFailure(Context context) {
            context.addErrors(this.messageFromMessageId.getComposedMessageId().getComposedMessageId());
            LOGGER.error("Failed to fix inconsistency for outdated message in MessageId: {}", (Object)this.messageFromMessageId.getComposedMessageId());
        }

        private void notifySuccess(Context context) {
            LOGGER.info("Inconsistency fixed for outdated message in MessageId: {}", (Object)this.messageFromMessageId.getComposedMessageId());
            context.incrementUpdatedMessageIdEntries();
            context.addFixedInconsistency(this.messageFromMessageId.getComposedMessageId().getComposedMessageId());
        }
    }

    private static class OrphanImapUidEntry
    implements Inconsistency {
        private final CassandraMessageMetadata message;

        private OrphanImapUidEntry(CassandraMessageMetadata message) {
            this.message = message;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO) {
            return messageIdDAO.insert(this.message).doOnSuccess(any -> this.notifySuccess(context)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                this.notifyFailure(context);
                return Mono.just((Object)Task.Result.PARTIAL);
            });
        }

        private void notifyFailure(Context context) {
            context.addErrors(this.message.getComposedMessageId().getComposedMessageId());
            LOGGER.error("Failed to fix inconsistency for orphan message in ImapUid: {}", (Object)this.message.getComposedMessageId());
        }

        private void notifySuccess(Context context) {
            LOGGER.info("Inconsistency fixed for orphan message in ImapUid: {}", (Object)this.message.getComposedMessageId());
            context.incrementAddedMessageIdEntries();
            context.addFixedInconsistency(this.message.getComposedMessageId().getComposedMessageId());
        }
    }

    private static class FailedToRetrieveRecord
    implements Inconsistency {
        private final CassandraMessageMetadata message;

        private FailedToRetrieveRecord(CassandraMessageMetadata message) {
            this.message = message;
        }

        @Override
        public Mono<Task.Result> fix(Context context, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO) {
            context.addErrors(this.message.getComposedMessageId().getComposedMessageId());
            LOGGER.error("Failed to retrieve record: {}", (Object)this.message.getComposedMessageId());
            return Mono.just((Object)Task.Result.PARTIAL);
        }
    }

    @FunctionalInterface
    static interface Inconsistency {
        public Mono<Task.Result> fix(Context var1, CassandraMessageIdToImapUidDAO var2, CassandraMessageIdDAO var3);
    }
}

