/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonParserSettings;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005}2Q\u0001B\u0003\u0001\u000b=A\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006I\u0001!\t!\n\u0005\u0006S\u0001!\tE\u000b\u0002\u0012\u0015N4\u0016\r\\;f'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\u0004\b\u0003\u001dQ\u0017mY6t_:T!\u0001C\u0005\u0002\t)\u001cxN\u001c\u0006\u0003\u0015-\tA\u0001\\5cg*\u0011A\"D\u0001\u0004CBL'\"\u0001\b\u0002\tAd\u0017-_\n\u0003\u0001A\u00012!E\r\u001c\u001b\u0005\u0011\"BA\n\u0015\u0003!!\u0017\r^1cS:$'B\u0001\u0004\u0016\u0015\t1r#A\u0005gCN$XM\u001d=nY*\t\u0001$A\u0002d_6L!A\u0007\n\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u0011A$H\u0007\u0002\u000f%\u0011ad\u0002\u0002\b\u0015N4\u0016\r\\;f\u00039\u0001\u0018M]:feN+G\u000f^5oON\u001c\u0001\u0001\u0005\u0002\u001dE%\u00111e\u0002\u0002\u0013\u0015N|g\u000eU1sg\u0016\u00148+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0003M!\u0002\"a\n\u0001\u000e\u0003\u0015AQa\b\u0002A\u0002\u0005\n\u0011b]3sS\u0006d\u0017N_3\u0015\t-\n4G\u000f\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005+:LG\u000fC\u00033\u0007\u0001\u00071$A\u0003wC2,X\rC\u0003\t\u0007\u0001\u0007A\u0007\u0005\u00026q5\taG\u0003\u00028)\u0005!1m\u001c:f\u0013\tIdGA\u0007Kg>tw)\u001a8fe\u0006$xN\u001d\u0005\u0006w\r\u0001\r\u0001P\u0001\taJ|g/\u001b3feB\u0011\u0011#P\u0005\u0003}I\u0011!cU3sS\u0006d\u0017N_3s!J|g/\u001b3fe\u0002")
public class JsValueSerializer
extends JsonSerializer<JsValue> {
    private final JsonParserSettings parserSettings;

    public void serialize(JsValue value, JsonGenerator json, SerializerProvider provider) {
        JsBoolean jsBoolean;
        Option<Object> option;
        JsValue jsValue = value;
        if (jsValue instanceof JsNumber) {
            BoxedUnit boxedUnit;
            String raw;
            JsNumber jsNumber = (JsNumber)jsValue;
            scala.math.BigDecimal v = jsNumber.value();
            scala.math.BigDecimal va = v.abs();
            boolean shouldWritePlain = va.$less((Object)this.parserSettings.bigDecimalSerializerSettings().maxPlain()) && va.$greater((Object)this.parserSettings.bigDecimalSerializerSettings().minPlain());
            BigDecimal stripped = v.bigDecimal().stripTrailingZeros();
            String string = raw = shouldWritePlain ? stripped.toPlainString() : stripped.toString();
            if (raw.indexOf(69) < 0 && raw.indexOf(46) < 0) {
                json.writeTree((TreeNode)new BigIntegerNode(new BigInteger(raw)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                json.writeTree((TreeNode)new DecimalNode(new BigDecimal(raw)));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String v = jsString.value();
            json.writeString(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsBoolean && !(option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)option.get());
            json.writeBoolean(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            IndexedSeq<JsValue> elements = jsArray.value();
            json.writeStartArray();
            elements.foreach((Function1 & Serializable)t -> {
                this.serialize(t, json, provider);
                return BoxedUnit.UNIT;
            });
            json.writeEndArray();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            Map<String, JsValue> values = jsObject.underlying$access$0();
            json.writeStartObject();
            values.foreach((Function1 & Serializable)t -> {
                JsValueSerializer.$anonfun$serialize$2(this, json, provider, t);
                return BoxedUnit.UNIT;
            });
            json.writeEndObject();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsNull$.MODULE$.equals(jsValue)) {
            json.writeNull();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jsValue);
        }
    }

    public static final /* synthetic */ void $anonfun$serialize$2(JsValueSerializer $this, JsonGenerator json$1, SerializerProvider provider$1, Tuple2 t) {
        json$1.writeFieldName((String)t._1());
        $this.serialize((JsValue)t._2(), json$1, provider$1);
    }

    public JsValueSerializer(JsonParserSettings parserSettings) {
        this.parserSettings = parserSettings;
    }
}

