/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.versions;

import java.util.Objects;
import org.apache.james.backends.cassandra.versions.SchemaVersion;

public class SchemaTransition {
    private final SchemaVersion toVersion;

    public static SchemaTransition to(SchemaVersion toVersion) {
        return new SchemaTransition(toVersion);
    }

    private SchemaTransition(SchemaVersion toVersion) {
        this.toVersion = toVersion;
    }

    public String fromAsString() {
        return String.valueOf(this.toVersion.previous().getValue());
    }

    public String toAsString() {
        return String.valueOf(this.toVersion.getValue());
    }

    public SchemaVersion from() {
        return this.toVersion.previous();
    }

    public SchemaVersion to() {
        return this.toVersion;
    }

    public final boolean equals(Object o) {
        if (o instanceof SchemaTransition) {
            SchemaTransition that = (SchemaTransition)o;
            return Objects.equals(this.toVersion, that.toVersion);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.toVersion);
    }

    public String toString() {
        return "SchemaTransition{ from " + this.fromAsString() + " to " + this.toAsString() + "}";
    }
}

