/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.upload;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.io.CountingInputStream;
import java.io.InputStream;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.Upload;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.model.UploadNotFoundException;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.cassandra.upload.BucketNameGenerator;
import org.apache.james.jmap.cassandra.upload.UploadBucketName;
import org.apache.james.jmap.cassandra.upload.UploadDAO;
import org.apache.james.mailbox.model.ContentType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public class CassandraUploadRepository
implements UploadRepository {
    private final UploadDAO uploadDAO;
    private final BlobStore blobStore;
    private final BucketNameGenerator bucketNameGenerator;

    @Inject
    public CassandraUploadRepository(UploadDAO uploadDAO, BlobStore blobStore, BucketNameGenerator bucketNameGenerator) {
        this.uploadDAO = uploadDAO;
        this.blobStore = blobStore;
        this.bucketNameGenerator = bucketNameGenerator;
    }

    public Publisher<UploadMetaData> upload(InputStream data, ContentType contentType, Username user) {
        UploadId uploadId = this.generateId();
        UploadBucketName uploadBucketName = this.bucketNameGenerator.current();
        BucketName bucketName = uploadBucketName.asBucketName();
        return Mono.fromCallable(() -> new CountingInputStream(data)).flatMap(countingInputStream -> Mono.from((Publisher)this.blobStore.save(bucketName, (InputStream)countingInputStream, BlobStore.StoragePolicy.LOW_COST)).map(blobId -> new UploadDAO.UploadRepresentation(uploadId, bucketName, (BlobId)blobId, contentType, countingInputStream.getCount(), user)).flatMap(upload -> this.uploadDAO.save((UploadDAO.UploadRepresentation)upload).thenReturn((Object)UploadMetaData.from((UploadId)uploadId, (ContentType)upload.getContentType(), (long)upload.getSize(), (BlobId)upload.getBlobId()))));
    }

    public Publisher<Upload> retrieve(UploadId id, Username user) {
        return this.uploadDAO.retrieve(id).filter(upload -> upload.getUser().equals((Object)user)).map(upload -> Upload.from((UploadMetaData)UploadMetaData.from((UploadId)id, (ContentType)upload.getContentType(), (long)upload.getSize(), (BlobId)upload.getBlobId()), () -> this.blobStore.read(upload.getBucketName(), upload.getBlobId(), BlobStore.StoragePolicy.LOW_COST))).switchIfEmpty(Mono.error(() -> new UploadNotFoundException(id)));
    }

    public Mono<Void> purge() {
        return Flux.from((Publisher)this.blobStore.listBuckets()).handle((bucketName, sink) -> UploadBucketName.ofBucket(bucketName).ifPresentOrElse(arg_0 -> ((SynchronousSink)sink).next(arg_0), () -> ((SynchronousSink)sink).complete())).filter(this.bucketNameGenerator.evictionPredicate()).concatMap(bucket -> this.blobStore.deleteBucket(bucket.asBucketName())).then();
    }

    private UploadId generateId() {
        return UploadId.from((UUID)Uuids.timeBased());
    }
}

