/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.Inject;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSchemaVersionStartUpCheck
implements StartUpCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraSchemaVersionStartUpCheck.class);
    static final String CHECK_NAME = "CassandraSchemaVersionStartUpCheck";
    private final CassandraSchemaVersionManager versionManager;

    @Inject
    public CassandraSchemaVersionStartUpCheck(CassandraSchemaVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public StartUpCheck.CheckResult check() {
        CassandraSchemaVersionManager.SchemaState schemaState = this.versionManager.computeSchemaState();
        switch (schemaState) {
            case TOO_OLD: {
                return this.checkTooOldState();
            }
            case TOO_RECENT: {
                return this.checkTooRecentState();
            }
            case UP_TO_DATE: {
                return this.checkUpToDateState();
            }
            case UPGRADABLE: {
                return this.checkUpgradeAbleState();
            }
        }
        String unknownSchemaStateMessage = "Unknown schema state " + schemaState;
        LOGGER.error(unknownSchemaStateMessage);
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(unknownSchemaStateMessage).build();
    }

    public String checkName() {
        return CHECK_NAME;
    }

    private StartUpCheck.CheckResult checkUpgradeAbleState() {
        String upgradeVersionMessage = String.format("Current schema version is %d. Recommended version is %d", ((SchemaVersion)this.versionManager.computeVersion().block()).getValue(), this.versionManager.getMaximumSupportedVersion().getValue());
        LOGGER.warn(upgradeVersionMessage);
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).description(upgradeVersionMessage).build();
    }

    private StartUpCheck.CheckResult checkUpToDateState() {
        String message = "Schema version is up-to-date";
        LOGGER.info(message);
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).description(message).build();
    }

    private StartUpCheck.CheckResult checkTooRecentState() {
        String versionExceedMaximumSupportedMessage = String.format("Current schema version is %d whereas the maximum supported version is %d. Recommended version is %d.", ((SchemaVersion)this.versionManager.computeVersion().block()).getValue(), this.versionManager.getMaximumSupportedVersion().getValue(), this.versionManager.getMaximumSupportedVersion().getValue());
        LOGGER.error(versionExceedMaximumSupportedMessage);
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(versionExceedMaximumSupportedMessage).build();
    }

    private StartUpCheck.CheckResult checkTooOldState() {
        String versionToOldMessage = String.format("Current schema version is %d whereas minimum required version is %d. Recommended version is %d", ((SchemaVersion)this.versionManager.computeVersion().block()).getValue(), this.versionManager.getMinimumSupportedVersion().getValue(), this.versionManager.getMaximumSupportedVersion().getValue());
        LOGGER.error(versionToOldMessage);
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(versionToOldMessage).build();
    }
}

