/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MultipleClassesDeserializer
extends StdDeserializer<Object> {
    private final Map<String, Class<?>> registry = new HashMap();

    MultipleClassesDeserializer() {
        super(Object.class);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode root = (JsonNode)mapper.readTree(p);
        return this.registry.entrySet().stream().filter(req -> !root.at((String)req.getKey()).isMissingNode()).map(x -> this.readValue(mapper, root, (Class)x.getValue())).findFirst().orElseThrow(() -> JsonMappingException.from((DeserializationContext)ctxt, (String)"Can't map request to a known registered class"));
    }

    private Object readValue(ObjectMapper mapper, JsonNode root, Class<?> clazz) {
        try {
            return mapper.treeToValue((TreeNode)root, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerClass(String uniqueJsonPath, Class<?> clazz) {
        Preconditions.checkArgument((!this.registry.containsKey(uniqueJsonPath) ? 1 : 0) != 0, (String)"Path %s has already been registered", (Object)uniqueJsonPath);
        this.registry.put(uniqueJsonPath, clazz);
    }
}

