/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.model.Filter;
import org.apache.james.jmap.draft.model.Operator;

@JsonDeserialize(builder=Builder.class)
public class FilterOperator
implements Filter {
    private final Operator operator;
    private final List<Filter> conditions;

    public static Builder builder() {
        return new Builder();
    }

    public static FilterOperator or(Filter ... filters) {
        Preconditions.checkArgument((filters.length > 0 ? 1 : 0) != 0);
        return FilterOperator.builder().operator(Operator.OR).conditions((List<Filter>)ImmutableList.copyOf((Object[])filters)).build();
    }

    public static FilterOperator and(Filter ... filters) {
        Preconditions.checkArgument((filters.length > 0 ? 1 : 0) != 0);
        return FilterOperator.builder().operator(Operator.AND).conditions((List<Filter>)ImmutableList.copyOf((Object[])filters)).build();
    }

    public static FilterOperator not(Filter ... filters) {
        Preconditions.checkArgument((filters.length > 0 ? 1 : 0) != 0);
        return FilterOperator.builder().operator(Operator.NOT).conditions((List<Filter>)ImmutableList.copyOf((Object[])filters)).build();
    }

    @VisibleForTesting
    FilterOperator(Operator operator, List<Filter> conditions) {
        this.operator = operator;
        this.conditions = conditions;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getConditions() {
        return this.conditions;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof FilterOperator) {
            FilterOperator other = (FilterOperator)obj;
            return Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.conditions, other.conditions);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.conditions});
    }

    public String toString() {
        return this.prettyPrint("");
    }

    @Override
    public String prettyPrint(String indentation) {
        return indentation + MoreObjects.toStringHelper(this.getClass()).add("operator", (Object)this.operator).toString() + "\n" + this.conditionListToString(indentation + "  ");
    }

    private String conditionListToString(String indentation) {
        return this.conditions.stream().map(condition -> condition.prettyPrint(indentation)).collect(Collectors.joining());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Operator operator;
        private final ImmutableList.Builder<Filter> conditionsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public Builder operator(Operator operator) {
            Preconditions.checkNotNull((Object)((Object)operator));
            this.operator = operator;
            return this;
        }

        public Builder conditions(List<Filter> conditions) {
            this.conditionsBuilder.addAll(conditions);
            return this;
        }

        public FilterOperator build() {
            Preconditions.checkState((this.operator != null ? 1 : 0) != 0, (Object)"'operator' is mandatory");
            ImmutableList conditions = this.conditionsBuilder.build();
            Preconditions.checkState((!conditions.isEmpty() ? 1 : 0) != 0, (Object)"'conditions' is mandatory");
            return new FilterOperator(this.operator, (List<Filter>)conditions);
        }
    }
}

