/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;

public class Header {
    private final String name;
    private final Optional<String> value;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public static Header from(List<String> header) {
        return Header.builder().header(header).build();
    }

    private Header(String name, Optional<String> value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public static class Builder {
        private String name;
        private Optional<String> value;

        public Builder header(List<String> header) {
            Preconditions.checkNotNull(header);
            Preconditions.checkArgument((header.size() > 0 ? 1 : 0) != 0, (Object)"'header' should contains at least one element");
            Preconditions.checkArgument((header.size() < 3 ? 1 : 0) != 0, (Object)"'header' should contains lesser than three elements");
            this.name = header.get(0);
            this.value = Optional.ofNullable((String)Iterables.get(header, (int)1, null));
            return this;
        }

        public Header build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"'name' is mandatory");
            return new Header(this.name, this.value);
        }
    }
}

