/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mdn.action.mode.DispositionActionMode;
import org.apache.james.mdn.sending.mode.DispositionSendingMode;
import org.apache.james.mdn.type.DispositionType;

@JsonDeserialize(builder=Builder.class)
public class MDNDisposition {
    private final DispositionActionMode actionMode;
    private final DispositionSendingMode sendingMode;
    private final DispositionType type;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MDNDisposition(DispositionActionMode actionMode, DispositionSendingMode sendingMode, DispositionType type) {
        this.actionMode = actionMode;
        this.sendingMode = sendingMode;
        this.type = type;
    }

    public DispositionActionMode getActionMode() {
        return this.actionMode;
    }

    public DispositionSendingMode getSendingMode() {
        return this.sendingMode;
    }

    public DispositionType getType() {
        return this.type;
    }

    public final boolean equals(Object o) {
        if (o instanceof MDNDisposition) {
            MDNDisposition that = (MDNDisposition)o;
            return Objects.equals(this.actionMode, that.actionMode) && Objects.equals(this.sendingMode, that.sendingMode) && Objects.equals(this.type, that.type);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.actionMode, this.sendingMode, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actionMode", (Object)this.actionMode).add("sendingMode", (Object)this.sendingMode).add("type", (Object)this.type).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private DispositionActionMode actionMode;
        private DispositionSendingMode sendingMode;
        private DispositionType type;

        public Builder actionMode(DispositionActionMode actionMode) {
            this.actionMode = actionMode;
            return this;
        }

        public Builder sendingMode(DispositionSendingMode sendingMode) {
            this.sendingMode = sendingMode;
            return this;
        }

        public Builder type(DispositionType type) {
            this.type = type;
            return this;
        }

        public MDNDisposition build() {
            Preconditions.checkState((this.actionMode != null ? 1 : 0) != 0, (Object)"'actionMode' is mandatory");
            Preconditions.checkState((this.sendingMode != null ? 1 : 0) != 0, (Object)"'sendingMode' is mandatory");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"'type' is mandatory");
            return new MDNDisposition(this.actionMode, this.sendingMode, this.type);
        }
    }
}

