/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Attachment;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;

@JsonDeserialize(builder=Builder.class)
public class SubMessage {
    private final ImmutableMap<String, String> headers;
    private final Optional<Emailer> from;
    private final ImmutableList<Emailer> to;
    private final ImmutableList<Emailer> cc;
    private final ImmutableList<Emailer> bcc;
    private final ImmutableList<Emailer> replyTo;
    private final String subject;
    private final Instant date;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;
    private final ImmutableList<Attachment> attachments;
    private final ImmutableMap<BlobId, SubMessage> attachedMessages;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SubMessage(ImmutableMap<String, String> headers, Optional<Emailer> from, ImmutableList<Emailer> to, ImmutableList<Emailer> cc, ImmutableList<Emailer> bcc, ImmutableList<Emailer> replyTo, String subject, Instant date, Optional<String> textBody, Optional<String> htmlBody, ImmutableList<Attachment> attachments, ImmutableMap<BlobId, SubMessage> attachedMessages) {
        this.headers = headers;
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.replyTo = replyTo;
        this.subject = subject;
        this.date = date;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.attachments = attachments;
        this.attachedMessages = attachedMessages;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<Emailer> getFrom() {
        return this.from;
    }

    public ImmutableList<Emailer> getTo() {
        return this.to;
    }

    public ImmutableList<Emailer> getCc() {
        return this.cc;
    }

    public ImmutableList<Emailer> getBcc() {
        return this.bcc;
    }

    public ImmutableList<Emailer> getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public Instant getDate() {
        return this.date;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public ImmutableList<Attachment> getAttachments() {
        return this.attachments;
    }

    public ImmutableMap<BlobId, SubMessage> getAttachedMessages() {
        return this.attachedMessages;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ImmutableMap<String, String> headers;
        private Emailer from;
        private final ImmutableList.Builder<Emailer> to;
        private final ImmutableList.Builder<Emailer> cc;
        private final ImmutableList.Builder<Emailer> bcc;
        private final ImmutableList.Builder<Emailer> replyTo;
        private String subject;
        private Instant date;
        private Optional<String> textBody = Optional.empty();
        private Optional<String> htmlBody = Optional.empty();
        private final ImmutableList.Builder<Attachment> attachments;
        private final ImmutableMap.Builder<BlobId, SubMessage> attachedMessages;

        private Builder() {
            this.to = ImmutableList.builder();
            this.cc = ImmutableList.builder();
            this.bcc = ImmutableList.builder();
            this.replyTo = ImmutableList.builder();
            this.attachments = ImmutableList.builder();
            this.attachedMessages = ImmutableMap.builder();
        }

        public Builder headers(ImmutableMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder from(Emailer from) {
            this.from = from;
            return this;
        }

        public Builder to(List<Emailer> to) {
            this.to.addAll(to);
            return this;
        }

        public Builder cc(List<Emailer> cc) {
            this.cc.addAll(cc);
            return this;
        }

        public Builder bcc(List<Emailer> bcc) {
            this.bcc.addAll(bcc);
            return this;
        }

        public Builder replyTo(List<Emailer> replyTo) {
            this.replyTo.addAll(replyTo);
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public Builder textBody(Optional<String> textBody) {
            this.textBody = textBody;
            return this;
        }

        public Builder htmlBody(Optional<String> htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            this.attachments.addAll(attachments);
            return this;
        }

        public Builder attachedMessages(Map<BlobId, SubMessage> attachedMessages) {
            this.attachedMessages.putAll(attachedMessages);
            return this;
        }

        public SubMessage build() {
            Preconditions.checkState((this.headers != null ? 1 : 0) != 0, (Object)"'headers' is mandatory");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.subject) ? 1 : 0) != 0, (Object)"'subject' is mandatory");
            Preconditions.checkState((this.date != null ? 1 : 0) != 0, (Object)"'date' is mandatory");
            ImmutableList attachments = this.attachments.build();
            ImmutableMap attachedMessages = this.attachedMessages.build();
            Preconditions.checkState((boolean)MessageFullView.areAttachedMessagesKeysInAttachments((ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages), (Object)"'attachedMessages' keys must be in 'attachements'");
            return new SubMessage(this.headers, Optional.ofNullable(this.from), (ImmutableList<Emailer>)this.to.build(), (ImmutableList<Emailer>)this.cc.build(), (ImmutableList<Emailer>)this.bcc.build(), (ImmutableList<Emailer>)this.replyTo.build(), this.subject, this.date, this.textBody, this.htmlBody, (ImmutableList<Attachment>)attachments, (ImmutableMap<BlobId, SubMessage>)attachedMessages);
        }
    }
}

