/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.james.util.streams.Iterators;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.builder.GraphBuilder;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DependencyGraph<T> {
    private final GraphBuilder<T, DefaultEdge, DefaultDirectedGraph<T, DefaultEdge>> builder;
    private final Function<T, Optional<T>> getParent;

    public DependencyGraph(Function<T, Optional<T>> getParent) {
        this.getParent = getParent;
        this.builder = new GraphBuilder((Graph)new DefaultDirectedGraph(DefaultEdge.class));
    }

    public void registerItem(T item) {
        this.builder.addVertex(item);
        this.getParent.apply(item).map(parentNode -> (GraphBuilder)this.builder.addEdge(parentNode, item));
    }

    public Stream<T> getBuildChain() throws CycleDetectedException {
        DefaultDirectedGraph graph = (DefaultDirectedGraph)this.builder.build();
        this.ensureNoCycle(graph);
        return Iterators.toStream((Iterator)new TopologicalOrderIterator((Graph)graph));
    }

    private void ensureNoCycle(DefaultDirectedGraph<T, DefaultEdge> graph) throws CycleDetectedException {
        CycleDetector cycleDetector = new CycleDetector(graph);
        if (cycleDetector.detectCycles()) {
            throw new CycleDetectedException();
        }
    }

    public String toString() {
        return ((DefaultDirectedGraph)this.builder.build()).toString();
    }

    public static class CycleDetectedException
    extends RuntimeException {
    }
}

