/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.SocketFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.net.SocketConnection;
import org.apache.derby.shared.common.error.StandardException;

public class ReplicationMessageTransmit {
    private final int DEFAULT_MESSAGE_RESPONSE_TIMEOUT = 30000;
    private final Object receiveSemaphore = new Object();
    private ReplicationMessage receivedMsg = null;
    private volatile boolean stopMessageReceiver = false;
    private final SlaveAddress slaveAddress;
    private SocketConnection socketConn;
    private String dbname;

    public ReplicationMessageTransmit(SlaveAddress slaveAddress) {
        this.slaveAddress = slaveAddress;
    }

    public void initConnection(int n, long l) throws IOException, StandardException, ClassNotFoundException {
        Socket socket = null;
        int n2 = n;
        SocketFactory socketFactory = SocketFactory.getDefault();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.slaveAddress.getHostAddress(), this.slaveAddress.getPortNumber());
        Socket socket2 = socketFactory.createSocket();
        socket2.connect(inetSocketAddress, n2);
        socket = socket2;
        socket.setKeepAlive(true);
        this.socketConn = new SocketConnection(socket);
        this.startMessageReceiverThread(this.dbname);
        this.brokerConnection(l);
    }

    public void tearDown() throws IOException {
        this.stopMessageReceiver = true;
        if (this.socketConn != null) {
            this.socketConn.tearDown();
            this.socketConn = null;
        }
    }

    public void sendMessage(ReplicationMessage replicationMessage) throws IOException {
        this.checkSocketConnection();
        this.socketConn.writeMessage(replicationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReplicationMessage sendMessageWaitForReply(ReplicationMessage replicationMessage) throws IOException, StandardException {
        this.receivedMsg = null;
        this.checkSocketConnection();
        this.socketConn.writeMessage(replicationMessage);
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (this.receivedMsg == null && l2 < 30000L) {
            Object object = this.receiveSemaphore;
            synchronized (object) {
                try {
                    this.receiveSemaphore.wait(30000L - l2);
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                    l2 = System.currentTimeMillis() - l;
                }
            }
        }
        if (this.receivedMsg == null) {
            throw StandardException.newException((String)"XRE04.C.2", (Object[])new Object[]{this.dbname});
        }
        return this.receivedMsg;
    }

    private void brokerConnection(long l) throws IOException, StandardException, ClassNotFoundException {
        ReplicationMessage replicationMessage = new ReplicationMessage(0, 1L);
        this.verifyMessageType(this.sendMessageWaitForReply(replicationMessage), 11);
        replicationMessage = new ReplicationMessage(1, l);
        this.verifyMessageType(this.sendMessageWaitForReply(replicationMessage), 11);
    }

    private boolean verifyMessageType(ReplicationMessage replicationMessage, int n) throws StandardException {
        if (replicationMessage.getType() == n) {
            return true;
        }
        if (replicationMessage.getType() == 12) {
            Object[] objectArray = (String[])replicationMessage.getMessage();
            throw StandardException.newException((String)objectArray[objectArray.length - 1], (Object[])objectArray);
        }
        throw StandardException.newException((String)"XRE03", (Object[])new Object[0]);
    }

    private void checkSocketConnection() throws IOException {
        if (this.socketConn == null) {
            throw new IOException("R012");
        }
    }

    private void startMessageReceiverThread(String string) {
        MasterReceiverThread masterReceiverThread = new MasterReceiverThread(string);
        masterReceiverThread.setDaemon(true);
        masterReceiverThread.start();
    }

    private class MasterReceiverThread
    extends Thread {
        private final ReplicationMessage pongMsg;

        MasterReceiverThread(String string) {
            super("derby.master.receiver-" + string);
            this.pongMsg = new ReplicationMessage(14, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ReplicationMessageTransmit.this.stopMessageReceiver) {
                try {
                    ReplicationMessage replicationMessage = this.readMessage();
                    switch (replicationMessage.getType()) {
                        case 13: {
                            ReplicationMessageTransmit.this.sendMessage(this.pongMsg);
                            break;
                        }
                        case 11: 
                        case 12: {
                            Object object = ReplicationMessageTransmit.this.receiveSemaphore;
                            synchronized (object) {
                                ReplicationMessageTransmit.this.receivedMsg = replicationMessage;
                                ReplicationMessageTransmit.this.receiveSemaphore.notify();
                                break;
                            }
                        }
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IOException iOException) {
                    ReplicationMessageTransmit.this.stopMessageReceiver = true;
                }
            }
        }

        private ReplicationMessage readMessage() throws ClassNotFoundException, IOException {
            ReplicationMessageTransmit.this.checkSocketConnection();
            return (ReplicationMessage)ReplicationMessageTransmit.this.socketConn.readMessage();
        }
    }
}

