/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.CRLFOutputStream;
import org.apache.james.jdkim.mailets.HeaderSkippingOutputStream;
import org.apache.james.jdkim.mailets.MimeMessageHeaders;
import org.apache.james.server.core.MimeMessageInputStream;

public class DKIMVerifier {
    private final org.apache.james.jdkim.DKIMVerifier originalVerifier;

    public DKIMVerifier(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.originalVerifier = new org.apache.james.jdkim.DKIMVerifier(publicKeyRecordRetriever);
    }

    public List<SignatureRecord> verifyUsingCRLF(MimeMessage message) throws MessagingException, FailException {
        return this.verify(message, true);
    }

    public List<SignatureRecord> verify(MimeMessage message, boolean forceCRLF) throws MessagingException, FailException {
        MimeMessageHeaders headers = new MimeMessageHeaders(message);
        BodyHasher bh = this.originalVerifier.newBodyHasher((Headers)headers);
        try {
            if (bh != null) {
                FilterOutputStream os = new HeaderSkippingOutputStream(bh.getOutputStream());
                if (forceCRLF) {
                    os = new CRLFOutputStream(os);
                }
                new MimeMessageInputStream(message).transferTo((OutputStream)os);
            }
        }
        catch (IOException e) {
            throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (bh != null) {
                    bh.getOutputStream().close();
                }
            }
            catch (IOException e) {
                throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
            }
        }
        return this.originalVerifier.verify(bh);
    }
}

