/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.postgres;

import java.time.LocalDateTime;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.postgres.extensions.types.Hstore;

public interface PostgresMailRepositoryDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresMailRepositoryUrlTable.TABLE}).addTable(new PostgresTable[]{PostgresMailRepositoryContentTable.TABLE}).build();

    public static interface PostgresMailRepositoryUrlTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"mail_repository_url");
        public static final Field<String> URL = DSL.field((String)"url", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(URL).primaryKey(new Field[]{URL})).disableRowLevelSecurity().build();
    }

    public static interface PostgresMailRepositoryContentTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"mail_repository_content");
        public static final Field<String> URL = DSL.field((String)"url", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<String> KEY = DSL.field((String)"key", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> STATE = DSL.field((String)"state", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> ERROR = DSL.field((String)"error", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> HEADER_BLOB_ID = DSL.field((String)"header_blob_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> BODY_BLOB_ID = DSL.field((String)"body_blob_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Hstore> ATTRIBUTES = DSL.field((String)"attributes", (DataType)PostgresCommons.DataTypes.HSTORE.notNull());
        public static final Field<String> SENDER = DSL.field((String)"sender", (DataType)SQLDataType.VARCHAR);
        public static final Field<String[]> RECIPIENTS = DSL.field((String)"recipients", (DataType)SQLDataType.VARCHAR.getArrayDataType().notNull());
        public static final Field<String> REMOTE_HOST = DSL.field((String)"remote_host", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> REMOTE_ADDRESS = DSL.field((String)"remote_address", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<LocalDateTime> LAST_UPDATED = DSL.field((String)"last_updated", (DataType)PostgresCommons.DataTypes.TIMESTAMP.notNull());
        public static final Field<Hstore> PER_RECIPIENT_SPECIFIC_HEADERS = DSL.field((String)"per_recipient_specific_headers", (DataType)PostgresCommons.DataTypes.HSTORE.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(URL).column(KEY).column(STATE).column(ERROR).column(HEADER_BLOB_ID).column(BODY_BLOB_ID).column(ATTRIBUTES).column(SENDER).column(RECIPIENTS).column(REMOTE_HOST).column(REMOTE_ADDRESS).column(LAST_UPDATED).column(PER_RECIPIENT_SPECIFIC_HEADERS).primaryKey(new Field[]{URL, KEY})).disableRowLevelSecurity().build();
    }
}

