/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.priority;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class SmtpMtPriorityParameters {
    public static final String MT_PRIORITY_PARAMETER = "MT-PRIORITY";
    public static final int MIN_MT_PRIORITY_VALUE = -9;
    public static final int MAX_MT_PRIORITY_VALUE = 9;
    public static final int DEFAULT_MT_PRIORITY_VALUE = 0;

    public static class MtPriority {
        private final int priorityValue;

        public static Integer defaultPriorityValue() {
            return 0;
        }

        public MtPriority(String value) {
            Preconditions.checkNotNull((Object)value);
            int priority = Integer.parseInt(value);
            if (priority < -9 || priority > 9) {
                throw new IllegalArgumentException("Invalid priority: According to RFC-6710 allowed values are from -9 to 9 inclusive");
            }
            this.priorityValue = priority;
        }

        public int getPriorityValue() {
            return this.priorityValue;
        }

        public String asString() {
            return String.valueOf(this.priorityValue);
        }

        public final boolean equals(Object o) {
            if (o instanceof MtPriority) {
                MtPriority that = (MtPriority)o;
                return Objects.equals(this.priorityValue, that.priorityValue);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.priorityValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("priority value", this.priorityValue).toString();
        }
    }
}

