/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rs!\u0002!B\u0011\u00031e!\u0002%B\u0011\u0003I\u0005\"\u0002)\u0002\t\u0003\tf\u0001\u0002*\u0002\u0001MC\u0001bZ\u0002\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\ts\u000e\u0011\t\u0011)A\u0005u\"Q\u00111B\u0002\u0003\u0002\u0003\u0006I!!\u0004\t\rA\u001bA\u0011AA\r\u0011\u001d\tic\u0001C!\u0003_Aq!a\u000e\u0004\t\u0003\nI\u0004C\u0004\u0002B\r!\t%!\u000f\t\u000f\u0005\r\u0013\u0001\"\u0003\u0002F!9\u0011qL\u0001\u0005\n\u0005\u0005\u0004bBA7\u0003\u0011\u0005\u0011q\u000e\u0005\b\u0003\u007f\nA\u0011AAA\r\u0015A\u0015\tAAC\u0011%\t)j\u0004B\u0001B\u0003%!\u0010\u0003\u0006\u0002t=\u0011\t\u0011)A\u0005\u0003kB!\"a&\u0010\u0005\u0003\u0005\u000b\u0011BAM\u0011)\tIk\u0004B\u0001B\u0003%\u00111\u0016\u0005\u000b\u0003k{!\u0011!Q\u0001\n\u0005]\u0006BCA_\u001f\t\u0005\t\u0015!\u0003\u0002@\"Q\u0011\u0011Z\b\u0003\u0002\u0003\u0006I!a3\t\u0015\u0005UwB!A!\u0002\u0013\t9\u000e\u0003\u0006\u0002^>\u0011)\u0019!C\u0001\u0003?D!B!\t\u0010\u0005\u0003\u0005\u000b\u0011BAq\u0011)\tYa\u0004B\u0001B\u0003%\u0011Q\u0002\u0005\u0007!>!\tAa\t\t\u0013\tmrB1A\u0005\u0002\tu\u0002\u0002\u0003B&\u001f\u0001\u0006IAa\u0010\t\u0013\t5sB1A\u0005\n\t=\u0003\u0002\u0003B,\u001f\u0001\u0006IA!\u0015\t\u0011e|!\u0019!C\u0005\u00053BqAa\u0017\u0010A\u0003%!\u0010C\u0005\u0003^=\u0011\r\u0011\"\u0003\u0003`!A!qM\b!\u0002\u0013\u0011\t\u0007C\u0005\u0003j=\u0011\r\u0011\"\u0003\u0003l!A!1O\b!\u0002\u0013\u0011i\u0007C\u0005\u0002l=\u0011\r\u0011\"\u0003\u0003v!A!qO\b!\u0002\u0013\t9\u0005C\u0005\u0003z=\u0011\r\u0011\"\u0003\u0003|!A!qP\b!\u0002\u0013\u0011i\bC\u0005\u0003\u0002>\u0011\r\u0011\"\u0011\u0003\u0004\"A!1R\b!\u0002\u0013\u0011)\tC\u0005\u0003\u000e>\u0011\r\u0011\"\u0003\u0003\u0010\"A!qS\b!\u0002\u0013\u0011\t\nC\u0005\u0003\u001a>\u0011\r\u0011\"\u0003\u0003\u001c\"A!\u0011V\b!\u0002\u0013\u0011i\nC\u0005\u0003,>\u0011\r\u0011\"\u0003\u0003.\"A!QW\b!\u0002\u0013\u0011y\u000b\u0003\u0005h\u001f\t\u0007I\u0011\tB\\\u0011!\u0011Yl\u0004Q\u0001\n\te\u0006\"\u0003B_\u001f\t\u0007I\u0011\u0002B`\u0011!\u0011im\u0004Q\u0001\n\t\u0005\u0007b\u0002Bh\u001f\u0011\u0005\u0011q\u0006\u0005\b\u0005#|A\u0011AA\u0018\u0011\u001d\u0011\u0019n\u0004C!\u0005+DqA!;\u0010\t\u0003\u0012Y\u000fC\u0004\u0004\u001a=!Iaa\u0007\t\u000f\ruq\u0002\"\u0003\u0004 !91\u0011E\b\u0005\n\r\r\u0002bBB\u0013\u001f\u0011%1q\u0005\u0005\b\u0007_yA\u0011BB\u0019\u0011\u001d\u0019Id\u0004C!\u0007w\t\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u000b\u0005\t\u001b\u0015\u0001\u0002:bMRT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001!\t9\u0015!D\u0001B\u0005AY\u0015MZ6b%\u00064G/T1oC\u001e,'o\u0005\u0002\u0002\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001$\u0003\u0019I\u000bg\r^%p)\"\u0014X-\u00193\u0014\u0007\r!\u0016\r\u0005\u0002V?6\taK\u0003\u0002X1\u0006!Q\u000f^5m\u0015\tI&,\u0001\u0004tKJ4XM\u001d\u0006\u0003\tnS!\u0001X/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0016aA8sO&\u0011\u0001M\u0016\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0005\u0002cK6\t1M\u0003\u0002e\u0007\u0006)Q\u000f^5mg&\u0011am\u0019\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019G.[3oiB\u0012\u0011\u000e\u001d\t\u0004U2tW\"A6\u000b\u0005\tS\u0016BA7l\u0005=Y\u0015MZ6b%\u00064Go\u00117jK:$\bCA8q\u0019\u0001!\u0011\"\u001d\u0003\u0002\u0002\u0003\u0005)\u0011\u0001:\u0003\u0007}#\u0013'\u0005\u0002tmB\u00111\n^\u0005\u0003k2\u0013qAT8uQ&tw\r\u0005\u0002Lo&\u0011\u0001\u0010\u0014\u0002\u0004\u0003:L\u0018\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y!\rY\u0018Q\u0001\b\u0004y\u0006\u0005\u0001CA?M\u001b\u0005q(BA@F\u0003\u0019a$o\\8u}%\u0019\u00111\u0001'\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0001T\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0001,A\u0003gCVdG/\u0003\u0003\u0002\u0018\u0005E!\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014H\u0003CA\u000e\u0003?\tI#a\u000b\u0011\u0007\u0005u1!D\u0001\u0002\u0011\u00199w\u00011\u0001\u0002\"A\"\u00111EA\u0014!\u0011QG.!\n\u0011\u0007=\f9\u0003\u0002\u0006r\u0003?\t\t\u0011!A\u0003\u0002IDQ!_\u0004A\u0002iDq!a\u0003\b\u0001\u0004\ti!\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003c\u00012aSA\u001a\u0013\r\t)\u0004\u0014\u0002\u0005+:LG/\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u00111\b\t\u0004\u0017\u0006u\u0012bAA \u0019\n9!i\\8mK\u0006t\u0017!C5t%Vtg.\u001b8h\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\r\u0005\u001d\u0013qKA.!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n!![8\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002L\t!a)\u001b7f\u0011\u001d\tIf\u0003a\u0001\u0003\u000f\na\u0001\\8h\t&\u0014\bBBA/\u0017\u0001\u0007!0\u0001\u0006m_\u001e$\u0015N\u001d(b[\u0016\f1\u0002\\8dW\u0012\u000bG/\u0019#jeR!\u00111MA5!\r\u0011\u0017QM\u0005\u0004\u0003O\u001a'\u0001\u0003$jY\u0016dunY6\t\u000f\u0005-D\u00021\u0001\u0002H\u00059A-\u0019;b\t&\u0014\u0018A\u00055bg\u0012KgMZ3sK:$Hj\\4ESJ$B!a\u000f\u0002r!9\u00111O\u0007A\u0002\u0005U\u0014AB2p]\u001aLw\r\u0005\u0003\u0002x\u0005mTBAA=\u0015\tI6)\u0003\u0003\u0002~\u0005e$aC&bM.\f7i\u001c8gS\u001e\f\u0011$\\1zE\u0016$U\r\\3uK6+G/\u00193bi\u0006dun\u001a#jeR!\u0011\u0011GAB\u0011\u001d\t\u0019H\u0004a\u0001\u0003k*B!a\"\u0002\u0012N)qBSAECB)q)a#\u0002\u0010&\u0019\u0011QR!\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0004_\u0006EEABAJ\u001f\t\u0007!OA\u0001U\u0003%\u0019G.^:uKJLE-A\u0006sK\u000e|'\u000fZ*fe\u0012,\u0007CBAN\u0003K\u000by)\u0004\u0002\u0002\u001e*!\u0011qTAQ\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0019\u00111\u0015-\u0002\r\r|W.\\8o\u0013\u0011\t9+!(\u0003\u0017I+7m\u001c:e'\u0016\u0014H-Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ti+!-\u000e\u0005\u0005=&bAAR5&!\u00111WAX\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0001^8qS\u000eLE\r\u0005\u0003\u0002.\u0006e\u0016\u0002BA^\u0003_\u0013A!V;jI\u0006!A/[7f!\u0011\t\t-!2\u000e\u0005\u0005\r'b\u00013\u00020&!\u0011qYAb\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011QZAi\u001b\t\tyM\u0003\u0003\u0002J\u0006=\u0016\u0002BAj\u0003\u001f\u0014q!T3ue&\u001c7/A\nuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq>\u0003H\u000f\u0005\u0003L\u00033T\u0018bAAn\u0019\n1q\n\u001d;j_:\fAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002bB1\u00111]Av\u0003_l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u000bG>t7-\u001e:sK:$(bA,\u0002P%!\u0011Q^As\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003c\f\u00190a>\u0003\u00045\u0011\u0011\u0011^\u0005\u0005\u0003k\fIOA\u0002NCB\u0004B!!?\u0002\u00006\u0011\u00111 \u0006\u0005\u0003{\fy%\u0001\u0003mC:<\u0017\u0002\u0002B\u0001\u0003w\u0014q!\u00138uK\u001e,'\u000f\u0005\u0003\u0003\u0006\tma\u0002\u0002B\u0004\u0005/qAA!\u0003\u0003\u00169!!1\u0002B\n\u001d\u0011\u0011iA!\u0005\u000f\u0007u\u0014y!C\u0001_\u0013\taV,\u0003\u0002E7&\u0011!IW\u0005\u0004\u00053Y\u0017A\u0003*bMR\u001cuN\u001c4jO&!!Q\u0004B\u0010\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\u0007\te1.A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!)Y\u0011)Ca\n\u0003*\t-\"Q\u0006B\u0018\u0005c\u0011\u0019D!\u000e\u00038\te\u0002\u0003B$\u0010\u0003\u001fCa!!&\u001c\u0001\u0004Q\bbBA:7\u0001\u0007\u0011Q\u000f\u0005\b\u0003/[\u0002\u0019AAM\u0011\u001d\tIk\u0007a\u0001\u0003WCq!!.\u001c\u0001\u0004\t9\fC\u0004\u0002>n\u0001\r!a0\t\u000f\u0005%7\u00041\u0001\u0002L\"9\u0011Q[\u000eA\u0002\u0005]\u0007bBAo7\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003\u0017Y\u0002\u0019AA\u0007\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0005\t}\u0002\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\u0007\t\u0015#,A\u0004dY&,g\u000e^:\n\t\t%#1\t\u0002\f\u0003BLg+\u001a:tS>t7/\u0001\u0007ba&4VM]:j_:\u001c\b%\u0001\u0006sC\u001a$8i\u001c8gS\u001e,\"A!\u0015\u0011\u0007)\u0014\u0019&C\u0002\u0003V-\u0014!BU1gi\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0016\u0003i\f\u0011\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=!\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0005C\u0002B!!1\u0003d%!!QMAb\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%A\u0005tG\",G-\u001e7feV\u0011!Q\u000e\t\u0004+\n=\u0014b\u0001B9-\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sAU\u0011\u0011qI\u0001\tI\u0006$\u0018\rR5sA\u0005YA-\u0019;b\t&\u0014Hj\\2l+\t\u0011i\bE\u0003L\u00033\f\u0019'\u0001\u0007eCR\fG)\u001b:M_\u000e\\\u0007%A\u0007sKBd\u0017nY1uK\u0012dunZ\u000b\u0003\u0005\u000b\u00032A\u001bBD\u0013\r\u0011Ii\u001b\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0002\u001dI,\u0007\u000f\\5dCR,G\rT8hA\u0005Qa.\u001a;DQ\u0006tg.\u001a7\u0016\u0005\tE\u0005c\u00016\u0003\u0014&\u0019!QS6\u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!Q\u0014\t\u0005\u0005?\u0013)+\u0004\u0002\u0003\"*\u0019!1\u0015,\u0002\u000bQLW.\u001a:\n\t\t\u001d&\u0011\u0015\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\t=\u0006cA$\u00032&\u0019!1W!\u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!+\t\u0011I\f\u0005\u0003kY\u0006=\u0015aB2mS\u0016tG\u000fI\u0001\re\u00064G/S8UQJ,\u0017\rZ\u000b\u0003\u0005\u0003\u00042Aa1\u0004\u001d\r\u0011)\r\u0001\b\u0005\u0005\u000f\u0014YMD\u0002~\u0005\u0013L\u0011\u0001R\u0005\u0003\u0005\u000e\u000bQB]1gi&{G\u000b\u001b:fC\u0012\u0004\u0013aB:uCJ$X\u000f]\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000f\u0006\u0003\u00022\t]\u0007b\u0002Bmq\u0001\u0007!1\\\u0001\tY&\u001cH/\u001a8feB1!Q\u001cBr\u0003\u001fs1A\u001bBp\u0013\r\u0011\to[\u0001\u000b%\u00064Go\u00117jK:$\u0018\u0002\u0002Bs\u0005O\u0014\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0004\u0005C\\\u0017!\u00045b]\u0012dWMU3rk\u0016\u001cH\u000f\u0006\u0005\u0003n\nm81BB\b!\u0019\t\u0019/a;\u0003pB!!\u0011\u001fB|\u001b\t\u0011\u0019P\u0003\u0003\u0003v\u0006=\u0016\u0001\u00039s_R|7m\u001c7\n\t\te(1\u001f\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007b\u0002B\u007fs\u0001\u0007!q`\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\r\u00051qA\u0007\u0003\u0007\u0007QAa!\u0002\u00020\u0006A!/Z9vKN$8/\u0003\u0003\u0004\n\r\r!!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0004\u000ee\u0002\rAa<\u0002\u000fI,\u0017/^3ti\"91\u0011C\u001dA\u0002\rM\u0011!D2sK\u0006$X\r\u001a+j[\u0016l5\u000fE\u0002L\u0007+I1aa\u0006M\u0005\u0011auN\\4\u0002\u001f\t,\u0018\u000e\u001c3SC\u001a$8\t\\5f]R$\"A!/\u0002'\t,\u0018\u000e\u001c3OKR<xN]6DQ\u0006tg.\u001a7\u0015\u0005\tE\u0015!D2sK\u0006$X\rR1uC\u0012K'\u000f\u0006\u0002\u0002H\u0005\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u0003\u0007S\u00012aRB\u0016\u0013\r\u0019i#\u0011\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\f!CY;jY\u0012tU\r^<pe.\u001cE.[3oiR\u001111\u0007\t\u0005\u0005\u0003\u001a)$\u0003\u0003\u00048\t\r#!\u0004(fi^|'o[\"mS\u0016tG/\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0016\u0005\ru\u0002c\u00016\u0004@%\u00191\u0011I6\u0003\u001d1+\u0017\rZ3s\u0003:$W\t]8dQ\u0002")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig kafkaConfig) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(kafkaConfig);
    }

    public static boolean hasDifferentLogDir(KafkaConfig kafkaConfig) {
        return KafkaRaftManager$.MODULE$.hasDifferentLogDir(kafkaConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationTimer().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftIoThread().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.client().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.netChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.replicatedLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.destroy();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.clusterId, nodeId, this.raftConfig());
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = UnifiedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.hasDifferentLogDir(config);
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

