/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.exception;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class LdapUnwillingToPerformException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapUnwillingToPerformException() {
        super(ResultCodeEnum.UNWILLING_TO_PERFORM, null);
    }

    public LdapUnwillingToPerformException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapUnwillingToPerformException(ResultCodeEnum resultCode, String message, Throwable cause) {
        super(message, cause);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapUnwillingToPerformException(String message) {
        super(ResultCodeEnum.UNWILLING_TO_PERFORM, message);
    }

    public LdapUnwillingToPerformException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case UNWILLING_TO_PERFORM: 
            case UNAVAILABLE_CRITICAL_EXTENSION: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13027_UNACCEPTABLE_RESULT_CODE, (Object[])new Object[]{resultCode}));
    }
}

