/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.SignatureVerificationCache;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.security.token.impl.TokenMAC;
import org.apache.knox.gateway.util.Tokens;

public abstract class AbstractJWTFilter
implements Filter {
    public static final String TOKEN_STATE_SERVICE_DISABLED_ERROR = "Error in token provider config: passcode use with knox.token.exp.server-managed set to false.";
    public static final String JWT_EXPECTED_ISSUER = "jwt.expected.issuer";
    public static final String JWT_DEFAULT_ISSUER = "KNOXSSO";
    public static final String TOKEN_PREFIX = "Token ";
    public static final String DISABLED_POSTFIX = " is disabled";
    public static final String IDLE_TIMEOUT_POSTFIX = " exceeded idle timeout";
    public static final String JWT_EXPECTED_SIGALG = "jwt.expected.sigalg";
    public static final String JWT_DEFAULT_SIGALG = "RS256";
    public static final String JWT_INSTANCE_KEY_FALLBACK = "jwt.instance.key.fallback";
    public static final boolean JWT_INSTANCE_KEY_FALLBACK_DEFAULT = false;
    static JWTMessages log = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    protected List<String> audiences;
    protected JWTokenAuthority authority;
    protected RSAPublicKey publicKey;
    protected SignatureVerificationCache signatureVerificationCache;
    private List<String> expectedIssuers;
    private String expectedSigAlg;
    protected String expectedPrincipalClaim;
    protected Set<URI> expectedJWKSUrls = new LinkedHashSet<URI>();
    protected Set<JOSEObjectType> allowedJwsTypes;
    private TokenStateService tokenStateService;
    private TokenMAC tokenMAC;
    protected long idleTimeoutSeconds = -1L;
    protected String topologyName;
    protected boolean isJwtInstanceKeyFallback = false;

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    public void init(FilterConfig filterConfig) throws ServletException {
        GatewayServices services;
        ServletContext context = filterConfig.getServletContext();
        if (context != null && (services = (GatewayServices)context.getAttribute("org.apache.knox.gateway.gateway.services")) != null) {
            this.authority = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
            if (TokenUtils.isServerManagedTokenStateEnabled((FilterConfig)filterConfig)) {
                this.tokenStateService = (TokenStateService)services.getService(ServiceType.TOKEN_STATE_SERVICE);
                try {
                    GatewayConfig config = (GatewayConfig)context.getAttribute("org.apache.knox.gateway.config");
                    AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
                    this.tokenMAC = new TokenMAC(config.getKnoxTokenHashAlgorithm(), aliasService.getPasswordFromAliasForGateway("knox.token.hash.key"));
                }
                catch (ServiceLifecycleException | AliasServiceException e) {
                    throw new ServletException("Error while initializing Knox token MAC generator", e);
                }
            }
        }
        this.topologyName = context != null ? (String)context.getAttribute("org.apache.knox.gateway.gateway.cluster") : null;
        this.signatureVerificationCache = SignatureVerificationCache.getInstance(this.topologyName, filterConfig);
        String fallbackConfig = filterConfig.getInitParameter(JWT_INSTANCE_KEY_FALLBACK);
        this.isJwtInstanceKeyFallback = fallbackConfig != null ? Boolean.parseBoolean(fallbackConfig) : false;
    }

    protected void configureExpectedParameters(FilterConfig filterConfig) {
        String expectedIssuersParam = filterConfig.getInitParameter(JWT_EXPECTED_ISSUER);
        if (expectedIssuersParam == null) {
            expectedIssuersParam = JWT_DEFAULT_ISSUER;
        }
        this.expectedIssuers = this.parseToListOfStrings(expectedIssuersParam);
        this.expectedSigAlg = filterConfig.getInitParameter(JWT_EXPECTED_SIGALG);
        if (StringUtils.isBlank((CharSequence)this.expectedSigAlg)) {
            this.expectedSigAlg = JWT_DEFAULT_SIGALG;
        }
    }

    protected List<String> parseToListOfStrings(String commaSeparatedList) {
        return Arrays.stream(commaSeparatedList.split(",")).map(String::trim).collect(Collectors.toList());
    }

    protected List<String> parseExpectedAudiences(String expectedAudiences) {
        ArrayList<String> audList = null;
        if (expectedAudiences != null && !expectedAudiences.isEmpty()) {
            String[] audArray = expectedAudiences.split(",");
            audList = new ArrayList<String>();
            for (String a : audArray) {
                audList.add(a.trim());
            }
        }
        return audList;
    }

    protected boolean tokenIsStillValid(JWT jwtToken) throws UnknownTokenException {
        Date expires = this.getServerManagedStateExpiration(TokenUtils.getTokenId((JWT)jwtToken));
        if (expires == null) {
            expires = jwtToken.getExpiresDate();
        }
        return expires == null || new Date().before(expires);
    }

    protected boolean tokenIsStillValid(String tokenId) throws UnknownTokenException {
        Date expires = this.getServerManagedStateExpiration(tokenId);
        return expires == null || new Date().before(expires);
    }

    private Date getServerManagedStateExpiration(String tokenId) throws UnknownTokenException {
        long value;
        Date expires = null;
        if (this.tokenStateService != null && (value = this.tokenStateService.getTokenExpiration(tokenId)) > 0L) {
            expires = new Date(value);
        }
        return expires;
    }

    protected boolean validateAudiences(JWT jwtToken) {
        boolean valid = false;
        String[] tokenAudienceList = jwtToken.getAudienceClaims();
        if (this.audiences == null) {
            valid = true;
        } else if (tokenAudienceList != null) {
            for (String aud : tokenAudienceList) {
                if (!this.audiences.contains(aud)) continue;
                log.jwtAudienceValidated();
                valid = true;
                break;
            }
        } else if (this.audiences.contains("NONE")) {
            log.jwtAudienceValidated();
            valid = true;
        }
        return valid;
    }

    public boolean isJWT(String token) {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            return false;
        }
        try {
            String header = new String(Base64.decodeBase64((String)parts[0]), StandardCharsets.UTF_8);
            return header.contains("\"alg\"");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        AuditContext context = auditService.getContext();
        if (context != null) {
            context.setUsername(SubjectUtils.getPrimaryPrincipalName((Subject)subject));
            auditService.attachContext(context);
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            if (sourceUri != null) {
                auditor.audit("authentication", sourceUri, "uri", "success");
            }
        }
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    public Subject createSubjectFromToken(String token) throws ParseException, UnknownTokenException {
        return this.createSubjectFromToken((JWT)new JWTToken(token));
    }

    protected Subject createSubjectFromToken(JWT token) throws UnknownTokenException {
        String principal = token.getSubject();
        String claimvalue = null;
        if (this.expectedPrincipalClaim != null) {
            claimvalue = token.getClaim(this.expectedPrincipalClaim);
        }
        return this.createSubjectFromTokenData(principal, claimvalue);
    }

    public Subject createSubjectFromTokenIdentifier(String tokenId) throws UnknownTokenException {
        TokenMetadata metadata = this.tokenStateService.getTokenMetadata(tokenId);
        if (metadata != null) {
            String username = metadata.isClientId() ? tokenId : metadata.getUserName();
            return this.createSubjectFromTokenData(username, null);
        }
        return null;
    }

    protected Subject createSubjectFromTokenData(String principal, String expectedPrincipalClaimValue) {
        String claimValue = expectedPrincipalClaimValue != null ? expectedPrincipalClaimValue.toLowerCase(Locale.ROOT) : null;
        HashSet emptySet = new HashSet();
        HashSet<PrimaryPrincipal> principals = new HashSet<PrimaryPrincipal>();
        PrimaryPrincipal p = new PrimaryPrincipal(claimValue != null ? claimValue : principal);
        principals.add(p);
        return new Subject(true, principals, emptySet, emptySet);
    }

    protected boolean validateToken(HttpServletRequest request, HttpServletResponse response, FilterChain chain, JWT token) throws IOException, ServletException {
        block14: {
            String tokenId = TokenUtils.getTokenId((JWT)token);
            String displayableTokenId = Tokens.getTokenIDDisplayText((String)tokenId);
            String displayableToken = Tokens.getTokenDisplayText((String)token.toString());
            if (this.expectedIssuers.contains(token.getIssuer())) {
                try {
                    if (this.tokenIsStillValid(token)) {
                        boolean audValid = this.validateAudiences(token);
                        if (audValid) {
                            Date nbf = token.getNotBeforeDate();
                            if (nbf == null || new Date().after(nbf)) {
                                TokenMetadata tokenMetadata;
                                TokenMetadata tokenMetadata2 = tokenMetadata = this.tokenStateService == null ? null : this.tokenStateService.getTokenMetadata(tokenId);
                                if (this.isTokenEnabled(tokenMetadata)) {
                                    if (this.isIdleTimeoutLimitNotExceeded(tokenMetadata)) {
                                        if (this.verifyTokenSignature(token)) {
                                            this.markLastUsedAt(tokenId, tokenMetadata);
                                            return true;
                                        }
                                        log.failedToVerifyTokenSignature(displayableToken, displayableTokenId);
                                        this.handleValidationError(request, response, 401, null);
                                    } else {
                                        log.idleTimoutExceeded(token.getSubject(), displayableTokenId, this.idleTimeoutSeconds);
                                        this.handleValidationError(request, response, 401, TOKEN_PREFIX + displayableTokenId + IDLE_TIMEOUT_POSTFIX);
                                    }
                                } else {
                                    log.disabledToken(displayableTokenId);
                                    this.handleValidationError(request, response, 401, TOKEN_PREFIX + displayableTokenId + DISABLED_POSTFIX);
                                }
                            } else {
                                log.notBeforeCheckFailed();
                                this.handleValidationError(request, response, 400, "Bad request: the NotBefore check failed");
                            }
                        } else {
                            log.failedToValidateAudience(displayableToken, displayableTokenId);
                            this.handleValidationError(request, response, 400, "Bad request: missing required token audience");
                        }
                        break block14;
                    }
                    log.tokenHasExpired(displayableToken, displayableTokenId);
                    this.removeSignatureVerificationRecord(token.toString());
                    this.handleValidationError(request, response, 401, "Token has expired");
                }
                catch (UnknownTokenException e) {
                    log.unableToVerifyExpiration((Exception)((Object)e));
                    this.handleValidationError(request, response, 401, e.getMessage());
                }
            } else {
                this.handleValidationError(request, response, 401, null);
            }
        }
        return false;
    }

    private boolean isTokenEnabled(TokenMetadata tokenMetadata) throws UnknownTokenException {
        return tokenMetadata == null ? true : tokenMetadata.isEnabled();
    }

    private boolean isIdleTimeoutLimitNotExceeded(TokenMetadata tokenMetadata) throws UnknownTokenException {
        if (this.idleTimeoutSeconds > 0L) {
            Instant idleTimeoutLimit;
            Instant lastUsedAt = tokenMetadata == null ? null : tokenMetadata.getLastUsedAt();
            Instant instant = idleTimeoutLimit = lastUsedAt == null ? null : lastUsedAt.plusSeconds(this.idleTimeoutSeconds);
            return idleTimeoutLimit == null ? true : tokenMetadata.isKnoxSsoCookie() && idleTimeoutLimit.isAfter(Instant.now());
        }
        return true;
    }

    private void markLastUsedAt(String tokenId, TokenMetadata tokenMetadata) throws UnknownTokenException {
        if (tokenMetadata != null && tokenMetadata.isKnoxSsoCookie()) {
            TokenMetadata updatedTokenMetadata = new TokenMetadata();
            updatedTokenMetadata.useTokenNow();
            this.tokenStateService.addMetadata(tokenId, updatedTokenMetadata);
        }
    }

    protected boolean validateToken(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String tokenId, String passcode) throws IOException, ServletException {
        block12: {
            String displayableTokenId;
            String string = displayableTokenId = tokenId == null ? "N/A" : Tokens.getTokenIDDisplayText((String)tokenId);
            if (this.tokenStateService != null) {
                try {
                    if (tokenId != null) {
                        if (this.tokenIsStillValid(tokenId)) {
                            TokenMetadata tokenMetadata;
                            TokenMetadata tokenMetadata2 = tokenMetadata = this.tokenStateService == null ? null : this.tokenStateService.getTokenMetadata(tokenId);
                            if (this.isTokenEnabled(tokenMetadata)) {
                                if (this.isIdleTimeoutLimitNotExceeded(tokenMetadata)) {
                                    if (this.hasSignatureBeenVerified(passcode) || this.validatePasscode(tokenId, passcode)) {
                                        this.markLastUsedAt(tokenId, tokenMetadata);
                                        return true;
                                    }
                                    log.wrongPasscodeToken(tokenId);
                                    this.handleValidationError(request, response, 401, "Invalid passcode");
                                } else {
                                    log.idleTimoutExceeded(tokenMetadata.getUserName(), displayableTokenId, this.idleTimeoutSeconds);
                                    this.handleValidationError(request, response, 401, TOKEN_PREFIX + displayableTokenId + IDLE_TIMEOUT_POSTFIX);
                                }
                            } else {
                                log.disabledToken(displayableTokenId);
                                this.handleValidationError(request, response, 401, TOKEN_PREFIX + displayableTokenId + DISABLED_POSTFIX);
                            }
                        } else {
                            log.tokenHasExpired(displayableTokenId);
                            this.removeSignatureVerificationRecord(passcode);
                            this.handleValidationError(request, response, 401, "Token has expired");
                        }
                        break block12;
                    }
                    log.missingTokenPasscode();
                    this.handleValidationError(request, response, 400, "Bad request: missing token passcode.");
                }
                catch (UnknownTokenException e) {
                    log.unableToVerifyExpiration((Exception)((Object)e));
                    this.handleValidationError(request, response, 401, e.getMessage());
                }
            } else {
                log.unableToVerifyPasscodeToken(displayableTokenId);
                this.handleValidationError(request, response, 401, TOKEN_STATE_SERVICE_DISABLED_ERROR);
            }
        }
        return false;
    }

    private boolean validatePasscode(String tokenId, String passcode) throws UnknownTokenException {
        long issueTime = this.tokenStateService.getTokenIssueTime(tokenId);
        TokenMetadata tokenMetadata = this.tokenStateService.getTokenMetadata(tokenId);
        String userName = tokenMetadata == null ? "" : tokenMetadata.getUserName();
        byte[] storedPasscode = tokenMetadata == null ? null : tokenMetadata.getPasscode().getBytes(StandardCharsets.UTF_8);
        boolean validPasscode = Arrays.equals(this.tokenMAC.hash(tokenId, issueTime, userName, passcode).getBytes(StandardCharsets.UTF_8), storedPasscode);
        if (validPasscode) {
            this.recordSignatureVerification(passcode);
        }
        return validPasscode;
    }

    protected boolean verifyTokenSignature(JWT token) {
        String serializedJWT = token.toString();
        boolean verified = this.hasSignatureBeenVerified(serializedJWT);
        if (!verified) {
            try {
                boolean attemptedPEMVerification = false;
                boolean attemptedJWKSVerification = false;
                if (this.publicKey != null) {
                    attemptedPEMVerification = true;
                    verified = this.authority.verifyToken(token, this.publicKey);
                    log.pemVerificationResultMessage(verified);
                }
                if (!verified && this.expectedJWKSUrls != null && !this.expectedJWKSUrls.isEmpty()) {
                    attemptedJWKSVerification = true;
                    verified = this.authority.verifyToken(token, this.expectedJWKSUrls, this.expectedSigAlg, this.allowedJwsTypes);
                    log.jwksVerificationResultMessage(verified);
                }
                if (!verified && (!attemptedPEMVerification && !attemptedJWKSVerification || this.isJwtInstanceKeyFallback)) {
                    verified = this.authority.verifyToken(token);
                    log.signingKeyVerificationResultMessage(verified);
                }
            }
            catch (TokenServiceException e) {
                log.unableToVerifyToken((Exception)((Object)e));
            }
            if (verified && this.expectedSigAlg != null) {
                try {
                    String receivedSigAlg = JWSHeader.parse((String)token.getHeader()).getAlgorithm().getName();
                    if (!receivedSigAlg.equals(this.expectedSigAlg)) {
                        verified = false;
                    }
                }
                catch (ParseException e) {
                    log.unableToVerifyToken(e);
                    verified = false;
                }
            }
            if (verified) {
                this.recordSignatureVerification(serializedJWT);
            }
        }
        return verified;
    }

    protected boolean hasSignatureBeenVerified(String token) {
        return this.signatureVerificationCache.hasSignatureBeenVerified(token);
    }

    protected void recordSignatureVerification(String token) {
        this.signatureVerificationCache.recordSignatureVerification(token);
    }

    protected void removeSignatureVerificationRecord(String token) {
        this.signatureVerificationCache.removeSignatureVerificationRecord(token);
    }

    protected abstract void handleValidationError(HttpServletRequest var1, HttpServletResponse var2, int var3, String var4) throws IOException;
}

