/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore.utils;

import java.lang.reflect.Constructor;
import org.apache.kyuubi.shaded.hive.metastore.api.MetaException;
import org.apache.kyuubi.shaded.hive.metastore.utils.ClassUtils;

public class JavaUtils {
    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JavaUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> clazz) throws MetaException {
        try {
            return Class.forName(className, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetaException(className + " class not found");
        }
    }

    public static <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initArgs) {
        if (parameterTypes.length != initArgs.length) {
            throw new IllegalArgumentException("Number of constructor parameter types doesn't match number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> clazz = ClassUtils.primitiveToWrapper(parameterTypes[i]);
            if (initArgs[i] == null || clazz.isInstance(initArgs[i])) continue;
            throw new IllegalArgumentException("Object : " + initArgs[i] + " is not an instance of " + clazz);
        }
        try {
            Constructor<T> meth = theClass.getDeclaredConstructor(parameterTypes);
            meth.setAccessible(true);
            return meth.newInstance(initArgs);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }
}

