/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.it;

import java.io.File;

import org.junit.jupiter.api.Test;

class MavenITmng7837ProjectElementInPomTest extends AbstractMavenIntegrationTestCase {

    protected MavenITmng7837ProjectElementInPomTest() {
        // Broken in 4.0.0-alpha-7
        super("(,4.0.0-alpha-7),(4.0.0-alpha-7,)");
    }

    @Test
    void testProjectElementInPom() throws Exception {
        File testDir = extractResources("/mng-7837-project-element-in-pom");

        final Verifier pluginVerifier = newVerifier(testDir.getPath());
        pluginVerifier.addCliArgument("validate");
        pluginVerifier.addCliArgument("-V");
        pluginVerifier.execute();
        pluginVerifier.verifyErrorFreeLog();
    }
}
