/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.EncryptionZoneManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTrashWithEncryptionZones {
    private Configuration conf;
    private FileSystemTestHelper fsHelper;
    private MiniDFSCluster cluster;
    private HdfsAdmin dfsAdmin;
    private DistributedFileSystem fs;
    private File testRootDir;
    private static final String TEST_KEY = "test_key";
    private FileSystemTestWrapper fsWrapper;
    private static Configuration clientConf;
    private static FsShell shell;
    private static AtomicInteger zoneCounter;
    private static AtomicInteger fileCounter;
    private static final int LEN = 8192;
    private static final EnumSet<CreateEncryptionZoneFlag> NO_TRASH;
    private static final EnumSet<CreateEncryptionZoneFlag> PROVISION_TRASH;

    private String getKeyProviderURI() {
        return "jceks://file" + new Path(this.testRootDir.toString(), "test.jks").toUri();
    }

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
        this.conf.set("hadoop.security.key.provider.path", this.getKeyProviderURI());
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        Logger.getLogger(EncryptionZoneManager.class).setLevel(Level.TRACE);
        this.fs = this.cluster.getFileSystem();
        this.fsWrapper = new FileSystemTestWrapper((FileSystem)this.fs);
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), this.conf);
        this.setProvider();
        DFSTestUtil.createKey(TEST_KEY, this.cluster, this.conf);
        clientConf = new Configuration(this.conf);
        clientConf.setLong("fs.trash.interval", 1L);
        shell = new FsShell(clientConf);
    }

    protected void setProvider() {
        this.fs.getClient().setKeyProvider((KeyProvider)this.cluster.getNameNode().getNamesystem().getProvider());
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testDeleteWithinEncryptionZone() throws Exception {
        Path zone = new Path("/zones");
        this.fs.mkdirs(zone);
        Path zone1 = new Path("/zones/zone" + zoneCounter.getAndIncrement());
        this.fs.mkdirs(zone1);
        this.dfsAdmin.createEncryptionZone(zone1, TEST_KEY, PROVISION_TRASH);
        Path encFile1 = new Path(zone1, "encFile" + fileCounter.getAndIncrement());
        DFSTestUtil.createFile((FileSystem)this.fs, encFile1, 8192L, (short)1, 65261L);
        DFSTestUtil.verifyDelete(shell, (FileSystem)this.fs, encFile1, true);
        DFSTestUtil.verifyDelete(shell, (FileSystem)this.fs, zone1, true);
    }

    @Test
    public void testDeleteEZWithMultipleUsers() throws Exception {
        Path zone = new Path("/zones");
        this.fs.mkdirs(zone);
        final Path zone1 = new Path("/zones/zone" + zoneCounter.getAndIncrement());
        this.fs.mkdirs(zone1);
        this.dfsAdmin.createEncryptionZone(zone1, TEST_KEY, NO_TRASH);
        this.fsWrapper.setPermission(zone1, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        Path encFile1 = new Path(zone1, "encFile" + fileCounter.getAndIncrement());
        DFSTestUtil.createFile((FileSystem)this.fs, encFile1, 8192L, (short)1, 65261L);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        final Path encFile2 = new Path(zone1, "encFile" + fileCounter.getAndIncrement());
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs2 = FileSystem.get((Configuration)TestTrashWithEncryptionZones.this.cluster.getConfiguration(0));
                DFSTestUtil.createFile(fs2, encFile2, 8192L, (short)1, 65261L);
                DFSTestUtil.verifyDelete(shell, (FileSystem)TestTrashWithEncryptionZones.this.fs, encFile2, true);
                String[] argv = new String[]{"-rm", "-r", zone1.toString()};
                int res = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)("Non-admin could delete an encryption zone with multiple users : " + zone1), (long)1L, (long)res);
                return null;
            }
        });
        shell = new FsShell(clientConf);
        DFSTestUtil.verifyDelete(shell, (FileSystem)this.fs, zone1, true);
    }

    static {
        zoneCounter = new AtomicInteger(1);
        fileCounter = new AtomicInteger(1);
        NO_TRASH = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);
        PROVISION_TRASH = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
    }
}

