/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.AddBlockPoolException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.PlatformAssumptions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeVolumeFailure {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeVolumeFailure.class);
    private final int block_size = 512;
    MiniDFSCluster cluster = null;
    private Configuration conf;
    final int dn_num = 2;
    final int blocks_num = 30;
    final short repl = (short)2;
    File dataDir = null;
    File data_fail = null;
    File failedDir = null;
    private FileSystem fs;
    final Map<String, BlockLocs> block_map = new HashMap<String, BlockLocs>();
    @Rule
    public Timeout timeout = new Timeout(120000);

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.conf.setInt("dfs.heartbeat.interval", 30);
        this.conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.dataDir = new File(this.cluster.getDataDirectory());
    }

    @After
    public void tearDown() throws Exception {
        if (this.data_fail != null) {
            FileUtil.setWritable((File)this.data_fail, (boolean)true);
            this.data_fail = null;
        }
        if (this.failedDir != null) {
            FileUtil.setWritable((File)this.failedDir, (boolean)true);
            this.failedDir = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=120000L)
    public void testVolumeFailure() throws Exception {
        System.out.println("Data dir: is " + this.dataDir.getPath());
        String filename = "/test.txt";
        Path filePath = new Path(filename);
        int filesize = 15360;
        DFSTestUtil.createFile(this.fs, filePath, filesize, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, filePath, (short)2);
        System.out.println("file " + filename + "(size " + filesize + ") is created and replicated");
        this.data_fail = this.cluster.getInstanceStorageDir(1, 0);
        this.failedDir = MiniDFSCluster.getFinalizedDir(this.data_fail, this.cluster.getNamesystem().getBlockPoolId());
        if (this.failedDir.exists() && !this.deteteBlocks(this.failedDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.failedDir + "'");
        }
        this.data_fail.setReadOnly();
        this.failedDir.setReadOnly();
        System.out.println("Deleteing " + this.failedDir.getPath() + "; exist=" + this.failedDir.exists());
        this.triggerFailure(filename, filesize);
        final DataNode dn = this.cluster.getDataNodes().get(1);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                VolumeFailureSummary summary = dn.getFSDataset().getVolumeFailureSummary();
                return summary != null && summary.getFailedStorageLocations() != null && summary.getFailedStorageLocations().length == 1;
            }
        }, (long)10L, (long)30000L);
        DataNodeTestUtils.triggerHeartbeat(dn);
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        BlockManagerTestUtil.checkHeartbeat(bm);
        Assert.assertEquals((long)1L, (long)this.cluster.getNamesystem().getVolumeFailuresTotal());
        this.verify(filename, filesize);
        System.out.println("creating file test1.txt");
        Path fileName1 = new Path("/test1.txt");
        DFSTestUtil.createFile(this.fs, fileName1, filesize, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, fileName1, (short)2);
        System.out.println("file " + fileName1.getName() + " is created and replicated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void testDnStartsAfterDiskErrorScanningBlockPool() throws Exception {
        this.cluster.shutdown(true);
        this.cluster.close();
        this.conf.set("dfs.datanode.fsdataset.factory", BadDiskFSDataset.Factory.class.getName());
        try (MiniDFSCluster localCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();){
            localCluster.waitActive();
            DataNode dn = localCluster.getDataNodes().get(0);
            try {
                localCluster.waitDatanodeFullyStarted(dn, 3000);
            }
            catch (TimeoutException e) {
                Assert.fail((String)"Datanode did not get fully started");
            }
            Assert.assertTrue((boolean)dn.isDatanodeUp());
            DataNodeTestUtils.triggerHeartbeat(dn);
            BlockManager bm = localCluster.getNamesystem().getBlockManager();
            BlockManagerTestUtil.checkHeartbeat(bm);
            Assert.assertEquals((long)1L, (long)localCluster.getNamesystem().getVolumeFailuresTotal());
        }
    }

    @Test(timeout=150000L)
    public void testFailedVolumeBeingRemovedFromDataNode() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        File dn0Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1);
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol1));
        DataStorage storage = dn0.getStorage();
        Assert.assertEquals((long)1L, (long)storage.getNumStorageDirs());
        for (int i = 0; i < storage.getNumStorageDirs(); ++i) {
            Storage.StorageDirectory sd = storage.getStorageDir(i);
            Assert.assertFalse((boolean)sd.getRoot().getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
        }
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        BlockPoolSliceStorage bpsStorage = storage.getBPStorage(bpid);
        Assert.assertEquals((long)1L, (long)bpsStorage.getNumStorageDirs());
        for (int i = 0; i < bpsStorage.getNumStorageDirs(); ++i) {
            Storage.StorageDirectory sd = bpsStorage.getStorageDir(i);
            Assert.assertFalse((boolean)sd.getRoot().getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
        }
        FsDatasetSpi data = dn0.getFSDataset();
        try (FsDatasetSpi.FsVolumeReferences vols = data.getFsVolumeReferences();){
            Iterator iterator = vols.iterator();
            while (iterator.hasNext()) {
                FsVolumeSpi volume = (FsVolumeSpi)iterator.next();
                Assert.assertFalse((boolean)new File(volume.getStorageLocation().getUri()).getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
            }
        }
        for (ReplicaInfo replica : FsDatasetTestUtil.getReplicas(data, bpid)) {
            Assert.assertNotNull((Object)replica.getVolume());
            Assert.assertFalse((boolean)new File(replica.getVolume().getStorageLocation().getUri()).getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
        }
        String[] dataDirStrs = dn0.getConf().get("dfs.datanode.data.dir").split(",");
        Assert.assertEquals((long)1L, (long)dataDirStrs.length);
        Assert.assertFalse((boolean)dataDirStrs[0].contains(dn0Vol1.getAbsolutePath()));
    }

    @Test(timeout=10000L)
    public void testDataNodeShutdownAfterNumFailedVolumeExceedsTolerated() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        File dn0Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn0Vol2 = this.cluster.getInstanceStorageDir(0, 1);
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1, dn0Vol2);
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol1));
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol2));
        dn0.checkDiskError();
        Assert.assertFalse((boolean)dn0.shouldRun());
    }

    @Test
    public void testVolumeFailureRecoveredByHotSwappingVolume() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        File dn0Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn0Vol2 = this.cluster.getInstanceStorageDir(0, 1);
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        String oldDataDirs = dn0.getConf().get("dfs.datanode.data.dir");
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol1));
        String dataDirs = dn0Vol2.getPath();
        Assert.assertThat((Object)dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", dataDirs), (Matcher)Is.is((Object)dn0.getConf().get("dfs.datanode.data.dir")));
        DataNodeTestUtils.restoreDataDirFromFailure(dn0Vol1);
        Assert.assertThat((Object)dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDirs), (Matcher)Is.is((Object)dn0.getConf().get("dfs.datanode.data.dir")));
        DataNodeTestUtils.injectDataDirFailure(dn0Vol2);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol2));
        Assert.assertTrue((boolean)dn0.shouldRun());
    }

    @Test(timeout=10000L)
    public void testRefreshDeadLock() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){

            public void delayWhenOfferServiceHoldLock() {
                try {
                    latch.await();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        DataNode dn = this.cluster.getDataNodes().get(0);
        File volume = this.cluster.getInstanceStorageDir(0, 0);
        String dataDirs = volume.getPath();
        List allBpOs = dn.getAllBpOs();
        BPOfferService service = (BPOfferService)allBpOs.get(0);
        BPServiceActor actor = (BPServiceActor)service.getBPServiceActors().get(0);
        DatanodeRegistration bpRegistration = actor.getBpRegistration();
        Thread register = new Thread(() -> {
            try {
                service.registrationSucceeded(actor, bpRegistration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        register.start();
        String newdir = dataDirs + "tmp";
        latch.countDown();
        String result = dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newdir);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testTolerateVolumeFailuresAfterAddingMoreVolumes() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        File dn0Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn0Vol2 = this.cluster.getInstanceStorageDir(0, 1);
        File dn0VolNew = new File(this.dataDir, "data_new");
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        String oldDataDirs = dn0.getConf().get("dfs.datanode.data.dir");
        Assert.assertThat((Object)dn0.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDirs + "," + dn0VolNew.getAbsolutePath()), (Matcher)Is.is((Object)dn0.getConf().get("dfs.datanode.data.dir")));
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol1));
        Assert.assertTrue((boolean)dn0.shouldRun());
        DataNodeTestUtils.injectDataDirFailure(dn0Vol2);
        DataNodeTestUtils.waitForDiskError(dn0, (FsVolumeSpi)DataNodeTestUtils.getVolume(dn0, dn0Vol2));
        dn0.checkDiskError();
        Assert.assertFalse((boolean)dn0.shouldRun());
    }

    @Test
    public void testUnderReplicationAfterVolFailure() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.cluster.startDataNodes(this.conf, 1, true, null, null);
        this.cluster.waitActive();
        final BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)3);
        File dn1Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn2Vol1 = this.cluster.getInstanceStorageDir(1, 0);
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)3);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                long underReplicatedBlocks = bm.getLowRedundancyBlocksCount() + bm.getPendingReconstructionBlocksCount();
                if (underReplicatedBlocks > 0L) {
                    return true;
                }
                LOG.info("There is no under replicated block after volume failure.");
                return false;
            }
        }, (long)500L, (long)60000L);
    }

    @Test(timeout=120000L)
    public void testDataNodeFailToStartWithVolumeFailure() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.failedDir = new File(this.dataDir, "failedDir");
        Assert.assertTrue((String)"Failed to fail a volume by setting it non-writable", (this.failedDir.mkdir() && this.failedDir.setReadOnly() ? 1 : 0) != 0);
        this.startNewDataNodeWithDiskFailure(new File(this.failedDir, "newDir1"), false);
    }

    @Test(timeout=120000L)
    public void testDNStartAndTolerateOneVolumeFailure() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.failedDir = new File(this.dataDir, "failedDir");
        Assert.assertTrue((String)"Failed to fail a volume by setting it non-writable", (this.failedDir.mkdir() && this.failedDir.setReadOnly() ? 1 : 0) != 0);
        this.startNewDataNodeWithDiskFailure(new File(this.failedDir, "newDir1"), true);
    }

    @Test(timeout=120000L)
    public void testDNFailToStartWithDataDirNonWritable() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        File readOnlyDir = new File(this.dataDir, "nonWritable");
        Assert.assertTrue((String)"Set the data dir permission non-writable", (readOnlyDir.mkdir() && readOnlyDir.setReadOnly() ? 1 : 0) != 0);
        this.startNewDataNodeWithDiskFailure(new File(readOnlyDir, "newDir1"), false);
    }

    @Test(timeout=120000L)
    public void testDNStartAndTolerateOneDataDirNonWritable() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        File readOnlyDir = new File(this.dataDir, "nonWritable");
        Assert.assertTrue((String)"Set the data dir permission non-writable", (readOnlyDir.mkdir() && readOnlyDir.setReadOnly() ? 1 : 0) != 0);
        this.startNewDataNodeWithDiskFailure(new File(readOnlyDir, "newDir1"), true);
    }

    private void startNewDataNodeWithDiskFailure(File badDataDir, boolean tolerated) throws Exception {
        File data5 = new File(this.dataDir, "data5");
        String newDirs = badDataDir.toString() + "," + data5.toString();
        Configuration newConf = new Configuration(this.conf);
        newConf.set("dfs.datanode.data.dir", newDirs);
        LOG.info("Setting dfs.datanode.data.dir for new DataNode as {}", (Object)newDirs);
        newConf.setInt("dfs.datanode.failed.volumes.tolerated", tolerated ? 1 : 0);
        Assert.assertEquals((long)2L, (long)this.cluster.getDataNodes().size());
        try {
            this.cluster.startDataNodes(newConf, 1, false, null, null);
            Assert.assertTrue((String)"Failed to get expected IOException", (boolean)tolerated);
        }
        catch (IOException ioe) {
            Assert.assertFalse((String)("Unexpected IOException " + ioe), (boolean)tolerated);
            return;
        }
        Assert.assertEquals((long)3L, (long)this.cluster.getDataNodes().size());
        Path p = new Path("/test1.txt");
        DFSTestUtil.createFile(this.fs, p, 15360L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, p, (short)3);
    }

    private void verify(String fn, int fs) throws IOException {
        int totalReal = this.countRealBlocks(this.block_map);
        System.out.println("countRealBlocks counted " + totalReal + " blocks");
        int totalNN = this.countNNBlocks(this.block_map, fn, fs);
        System.out.println("countNNBlocks counted " + totalNN + " blocks");
        for (String bid : this.block_map.keySet()) {
            BlockLocs bl = this.block_map.get(bid);
            Assert.assertEquals((String)"Num files should match num locations", (long)bl.num_files, (long)bl.num_locs);
        }
        Assert.assertEquals((String)"Num physical blocks should match num stored in the NN", (long)totalReal, (long)totalNN);
        FSNamesystem fsn = this.cluster.getNamesystem();
        BlockManagerTestUtil.getComputedDatanodeWork(fsn.getBlockManager());
        long underRepl = fsn.getUnderReplicatedBlocks();
        long pendRepl = fsn.getPendingReplicationBlocks();
        long totalRepl = underRepl + pendRepl;
        System.out.println("underreplicated after = " + underRepl + " and pending repl =" + pendRepl + "; total underRepl = " + totalRepl);
        System.out.println("total blocks (real and replicating):" + ((long)totalReal + totalRepl) + " vs. all files blocks " + 60);
        Assert.assertEquals((String)"Incorrect total block count", (long)((long)totalReal + totalRepl), (long)60L);
    }

    private void triggerFailure(String path, long size) throws IOException {
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            DatanodeInfoWithStorage dinfo = lb.getLocations()[1];
            ExtendedBlock b = lb.getBlock();
            try {
                this.accessBlock((DatanodeInfo)dinfo, lb);
            }
            catch (IOException e) {
                System.out.println("Failure triggered, on block: " + b.getBlockId() + "; corresponding volume should be removed by now");
                break;
            }
        }
    }

    private boolean deteteBlocks(File dir) {
        Collection fileList = FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File f : fileList) {
            if (!f.getName().startsWith("blk_")) continue;
            System.out.println("Deleting file " + f);
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    private void accessBlock(DatanodeInfo datanode, LocatedBlock lblock) throws IOException {
        InetSocketAddress targetAddr = null;
        ExtendedBlock block = lblock.getBlock();
        targetAddr = NetUtils.createSocketAddr((String)datanode.getXferAddr());
        BlockReader blockReader = new BlockReaderFactory(new DfsClientConf(this.conf)).setInetSocketAddress(targetAddr).setBlock(block).setFileName(BlockReaderFactory.getFileName((InetSocketAddress)targetAddr, (String)"test-blockpoolid", (long)block.getBlockId())).setBlockToken(lblock.getBlockToken()).setStartOffset(0L).setLength(0L).setVerifyChecksum(true).setClientName("TestDataNodeVolumeFailure").setDatanodeInfo(datanode).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setClientCacheContext(ClientContext.getFromConf((Configuration)this.conf)).setConfiguration(this.conf).setRemotePeerFactory(new RemotePeerFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                Peer peer = null;
                Socket sock = NetUtils.getDefaultSocketFactory((Configuration)TestDataNodeVolumeFailure.this.conf).createSocket();
                try {
                    sock.connect(addr, 60000);
                    sock.setSoTimeout(60000);
                    peer = DFSUtilClient.peerFromSocket((Socket)sock);
                }
                finally {
                    if (peer == null) {
                        IOUtils.closeSocket((Socket)sock);
                    }
                }
                return peer;
            }
        }).build();
        blockReader.close();
    }

    private int countNNBlocks(Map<String, BlockLocs> map, String path, long size) throws IOException {
        int total = 0;
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            String blockId = "" + lb.getBlock().getBlockId();
            DatanodeInfoWithStorage[] dn_locs = lb.getLocations();
            BlockLocs bl = map.get(blockId);
            if (bl == null) {
                bl = new BlockLocs();
            }
            total += dn_locs.length;
            bl.num_locs += dn_locs.length;
            map.put(blockId, bl);
        }
        return total;
    }

    private int countRealBlocks(Map<String, BlockLocs> map) {
        int total = 0;
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                if (dir == null) {
                    System.out.println("dir is null for dn=" + i + " and data_dir=" + j);
                    continue;
                }
                List<File> res = MiniDFSCluster.getAllBlockMetadataFiles(dir);
                if (res == null) {
                    System.out.println("res is null for dir = " + dir + " i=" + i + " and j=" + j);
                    continue;
                }
                for (File f : res) {
                    String s = f.getName();
                    Assert.assertNotNull((String)"Block file name should not be null", (Object)s);
                    String bid = s.substring(s.indexOf("_") + 1, s.lastIndexOf("_"));
                    BlockLocs val = map.get(bid);
                    if (val == null) {
                        val = new BlockLocs();
                    }
                    ++val.num_files;
                    map.put(bid, val);
                }
                total += res.size();
            }
        }
        return total;
    }

    @Test(timeout=120000L)
    public void testVolumeFailureDuringStartup() throws Exception {
        LOG.debug("Data dir: is " + this.dataDir.getPath());
        this.data_fail = this.cluster.getInstanceStorageDir(1, 0);
        this.failedDir = MiniDFSCluster.getFinalizedDir(this.data_fail, this.cluster.getNamesystem().getBlockPoolId());
        this.failedDir.setReadOnly();
        this.cluster.restartDataNode(1);
        final DataNode dn = this.cluster.getDataNodes().get(1);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return dn.getFSDataset() != null && dn.getFSDataset().getVolumeFailureSummary() != null && dn.getFSDataset().getVolumeFailureSummary().getFailedStorageLocations() != null && dn.getFSDataset().getVolumeFailureSummary().getFailedStorageLocations().length == 1;
            }
        }, (long)10L, (long)30000L);
    }

    @Test
    public void testVolumeFailureTwo() throws Exception {
        this.data_fail = this.cluster.getInstanceStorageDir(1, 0);
        this.failedDir = MiniDFSCluster.getFinalizedDir(this.data_fail, this.cluster.getNamesystem().getBlockPoolId());
        this.failedDir.setReadOnly();
        this.data_fail = this.cluster.getInstanceStorageDir(1, 1);
        this.failedDir = MiniDFSCluster.getFinalizedDir(this.data_fail, this.cluster.getNamesystem().getBlockPoolId());
        this.failedDir.setReadOnly();
        DataNode dn = this.cluster.getDataNodes().get(1);
        dn.checkDiskError();
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        long volumeFailures = MetricsAsserts.getLongCounter((String)"VolumeFailures", (MetricsRecordBuilder)rb);
        Assert.assertEquals((long)2L, (long)volumeFailures);
    }

    private static class BadDiskFSDataset
    extends SimulatedFSDataset {
        private String[] failedStorageLocations = null;

        BadDiskFSDataset(DataStorage storage, Configuration conf) {
            super(storage, conf);
        }

        @Override
        public void addBlockPool(String bpid, Configuration conf) {
            super.addBlockPool(bpid, conf);
            HashMap<SimulatedFSDataset.SimulatedVolume, IOException> unhealthyDataDirs = new HashMap<SimulatedFSDataset.SimulatedVolume, IOException>();
            unhealthyDataDirs.put(this.getStorages().get(0).getVolume(), new IOException());
            throw new AddBlockPoolException(unhealthyDataDirs);
        }

        @Override
        public synchronized void removeVolumes(Collection<StorageLocation> volumes, boolean clearFailure) {
            Iterator<StorageLocation> itr = volumes.iterator();
            String[] failedLocations = new String[volumes.size()];
            int index = 0;
            while (itr.hasNext()) {
                StorageLocation s = itr.next();
                failedLocations[index] = s.getUri().getPath();
                ++index;
            }
            this.failedStorageLocations = failedLocations;
        }

        @Override
        public void handleVolumeFailures(Set<FsVolumeSpi> failedVolumes) {
        }

        @Override
        public VolumeFailureSummary getVolumeFailureSummary() {
            if (this.failedStorageLocations != null) {
                return new VolumeFailureSummary(this.failedStorageLocations, 0L, 0L);
            }
            return new VolumeFailureSummary(ArrayUtils.EMPTY_STRING_ARRAY, 0L, 0L);
        }

        static class Factory
        extends FsDatasetSpi.Factory<BadDiskFSDataset> {
            Factory() {
            }

            public BadDiskFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
                return new BadDiskFSDataset(storage, conf);
            }

            public boolean isSimulated() {
                return true;
            }
        }
    }

    private class BlockLocs {
        public int num_files = 0;
        public int num_locs = 0;

        private BlockLocs() {
        }
    }
}

