/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyPersistPolicy
extends LazyPersistTestCase {
    @Test
    public void testPolicyNotSetByDefault() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, false);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)IsNot.not((Object)15));
    }

    @Test
    public void testPolicyPropagation() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }

    @Test
    public void testPolicyPersistenceInEditLog() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        this.cluster.restartNameNode(true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }

    @Test
    public void testPolicyPersistenceInFsImage() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0L, true);
        this.fs.setSafeMode(SafeModeAction.ENTER);
        this.fs.saveNamespace();
        this.fs.setSafeMode(SafeModeAction.LEAVE);
        this.cluster.restartNameNode(true);
        HdfsFileStatus status = this.client.getFileInfo(path.toString());
        Assert.assertThat((Object)status.getStoragePolicy(), (Matcher)Is.is((Object)15));
    }
}

