/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerImpl;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    private static final Logger LOG = LoggerFactory.getLogger(RpcRetryingCallerFactory.class);
    protected final Configuration conf;
    private final long pause;
    private final long pauseForCQTBE;
    private final int retries;
    private final int rpcTimeout;
    private final RetryingCallerInterceptor interceptor;
    private final int startLogErrorsCnt;
    private final boolean enableBackPressure;
    private ServerStatisticTracker stats;

    public RpcRetryingCallerFactory(Configuration conf) {
        this(conf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR);
    }

    public RpcRetryingCallerFactory(Configuration conf, RetryingCallerInterceptor interceptor) {
        this.conf = conf;
        this.pause = conf.getLong("hbase.client.pause", 100L);
        long configuredPauseForCQTBE = conf.getLong("hbase.client.pause.cqtbe", this.pause);
        if (configuredPauseForCQTBE < this.pause) {
            LOG.warn("The hbase.client.pause.cqtbe setting: " + configuredPauseForCQTBE + " is smaller than " + "hbase.client.pause" + ", will use " + this.pause + " instead.");
            this.pauseForCQTBE = this.pause;
        } else {
            this.pauseForCQTBE = configuredPauseForCQTBE;
        }
        this.retries = conf.getInt("hbase.client.retries.number", 15);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 5);
        this.interceptor = interceptor;
        this.enableBackPressure = conf.getBoolean("hbase.client.backpressure.enabled", false);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
    }

    public void setStatisticTracker(ServerStatisticTracker statisticTracker) {
        this.stats = statisticTracker;
    }

    public <T> RpcRetryingCaller<T> newCaller(int rpcTimeout) {
        RpcRetryingCallerImpl caller = new RpcRetryingCallerImpl(this.pause, this.pauseForCQTBE, this.retries, this.interceptor, this.startLogErrorsCnt, rpcTimeout);
        return caller;
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        RpcRetryingCallerImpl caller = new RpcRetryingCallerImpl(this.pause, this.pauseForCQTBE, this.retries, this.interceptor, this.startLogErrorsCnt, this.rpcTimeout);
        return caller;
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration) {
        return RpcRetryingCallerFactory.instantiate(configuration, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, null);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, ServerStatisticTracker stats) {
        return RpcRetryingCallerFactory.instantiate(configuration, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, stats);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, RetryingCallerInterceptor interceptor, ServerStatisticTracker stats) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        RpcRetryingCallerFactory factory = rpcCallerFactoryClazz.equals(clazzName) ? new RpcRetryingCallerFactory(configuration, interceptor) : (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcCallerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
        factory.setStatisticTracker(stats);
        return factory;
    }
}

