/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class LoadDatabase {
    final Context context;
    final TaskTracker tracker;
    private final DatabaseEvent event;
    private final String dbNameToLoadIn;

    public LoadDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(loadTaskTracker);
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            Database dbInMetadata = this.readDbMetadata();
            String dbName = dbInMetadata.getName();
            Task<? extends Serializable> dbRootTask = null;
            ReplUtils.ReplLoadOpType loadDbType = this.getLoadDbType(dbName);
            switch (loadDbType) {
                case LOAD_NEW: {
                    dbRootTask = this.createDbTask(dbInMetadata);
                    break;
                }
                case LOAD_REPLACE: {
                    dbRootTask = this.alterDbTask(dbInMetadata);
                    break;
                }
            }
            if (dbRootTask != null) {
                dbRootTask.addDependentTask(this.setOwnerInfoTask(dbInMetadata));
                this.tracker.addTask(dbRootTask);
            }
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    Database readDbMetadata() throws SemanticException {
        return this.event.dbInMetadata(this.dbNameToLoadIn);
    }

    private ReplUtils.ReplLoadOpType getLoadDbType(String dbName) throws InvalidOperationException, HiveException {
        Database db = this.context.hiveDb.getDatabase(dbName);
        if (db == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (this.isDbAlreadyBootstrapped(db)) {
            throw new InvalidOperationException("Bootstrap REPL LOAD is not allowed on Database: " + dbName + " as it was already done.");
        }
        if (ReplUtils.replCkptStatus(dbName, db.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        if (this.isDbEmpty(dbName)) {
            return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
        }
        throw new InvalidOperationException("Bootstrap REPL LOAD is not allowed on Database: " + dbName + " as it is not empty. One or more tables/functions exist.");
    }

    private boolean isDbAlreadyBootstrapped(Database db) {
        Map props = db.getParameters();
        return props != null && props.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString()) && !((String)props.get(ReplicationSpec.KEY.CURR_STATE_ID.toString())).isEmpty();
    }

    private boolean isDbEmpty(String dbName) throws HiveException {
        List<String> allTables = this.context.hiveDb.getAllTables(dbName);
        List<String> allFunctions = this.context.hiveDb.getFunctions(dbName, "*");
        return allTables.isEmpty() && allFunctions.isEmpty();
    }

    private Task<? extends Serializable> createDbTask(Database dbObj) {
        CreateDatabaseDesc createDbDesc = new CreateDatabaseDesc();
        createDbDesc.setName(dbObj.getName());
        createDbDesc.setComment(dbObj.getDescription());
        createDbDesc.setDatabaseProperties(LoadDatabase.updateDbProps(dbObj, this.context.dumpDirectory));
        createDbDesc.setIfNotExists(false);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), createDbDesc);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private Task<? extends Serializable> alterDbTask(Database dbObj) {
        return LoadDatabase.alterDbTask(dbObj.getName(), LoadDatabase.updateDbProps(dbObj, this.context.dumpDirectory), this.context.hiveConf);
    }

    private Task<? extends Serializable> setOwnerInfoTask(Database dbObj) {
        AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbObj.getName(), new PrincipalDesc(dbObj.getOwnerName(), dbObj.getOwnerType()), null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private static Map<String, String> updateDbProps(Database dbObj, String dumpDirectory) {
        HashMap<String, String> parameters = new HashMap<String, String>(dbObj.getParameters());
        parameters.remove(ReplicationSpec.KEY.CURR_STATE_ID.toString());
        parameters.put("hive.repl.ckpt.key", dumpDirectory);
        return parameters;
    }

    private static Task<? extends Serializable> alterDbTask(String dbName, Map<String, String> props, HiveConf hiveConf) {
        AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbName, props, null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc);
        return TaskFactory.get(work, hiveConf);
    }

    public static class AlterDatabase
    extends LoadDatabase {
        public AlterDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
            super(context, event, dbNameToLoadIn, loadTaskTracker);
        }

        @Override
        public TaskTracker tasks() throws SemanticException {
            Database dbObj = this.readDbMetadata();
            this.tracker.addTask(LoadDatabase.alterDbTask(dbObj.getName(), dbObj.getParameters(), this.context.hiveConf));
            return this.tracker;
        }
    }
}

