/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.Constants;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.PrintSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;

public class LLAPioSummary
implements PrintSummary {
    private static final String LLAP_SUMMARY_HEADER_FORMAT = "%10s %9s %9s %10s %9s %10s %9s";
    private static final String LLAP_IO_SUMMARY_HEADER = "LLAP IO Summary";
    private static final String LLAP_SUMMARY_HEADER = String.format("%10s %9s %9s %10s %9s %10s %9s", "VERTICES", "ROWGROUPS", "META_HIT", "META_MISS", "DATA_HIT", "DATA_MISS", "TOTAL_IO");
    private final DecimalFormat secondsFormatter = new DecimalFormat("#0.00");
    private Map<String, Progress> progressMap;
    private DAGClient dagClient;
    private boolean first = false;

    LLAPioSummary(Map<String, Progress> progressMap, DAGClient dagClient) {
        this.progressMap = progressMap;
        this.dagClient = dagClient;
    }

    @Override
    public void print(SessionState.LogHelper console) {
        console.printInfo("");
        console.printInfo(LLAP_IO_SUMMARY_HEADER);
        TreeSet<String> keys = new TreeSet<String>(this.progressMap.keySet());
        HashSet<StatusGetOpts> statusOptions = new HashSet<StatusGetOpts>(1);
        statusOptions.add(StatusGetOpts.GET_COUNTERS);
        String counterGroup = LlapIOCounters.class.getName();
        for (String vertexName : keys) {
            TezCounters vertexCounters;
            if (vertexName.startsWith("Reducer") || (vertexCounters = this.vertexCounter(statusOptions, vertexName)) == null) continue;
            if (!this.first) {
                console.printInfo(Constants.SEPARATOR);
                console.printInfo(LLAP_SUMMARY_HEADER);
                console.printInfo(Constants.SEPARATOR);
                this.first = true;
            }
            console.printInfo(this.vertexSummary(vertexName, counterGroup, vertexCounters));
        }
        console.printInfo(Constants.SEPARATOR);
        console.printInfo("");
    }

    private String vertexSummary(String vertexName, String counterGroup, TezCounters vertexCounters) {
        long selectedRowgroups = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.SELECTED_ROWGROUPS.name());
        long metadataCacheHit = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.METADATA_CACHE_HIT.name());
        long metadataCacheMiss = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.METADATA_CACHE_MISS.name());
        long cacheHitBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.CACHE_HIT_BYTES.name());
        long cacheMissBytes = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.CACHE_MISS_BYTES.name());
        long totalIoTime = TezJobMonitor.getCounterValueByGroupName(vertexCounters, counterGroup, LlapIOCounters.TOTAL_IO_TIME_NS.name());
        return String.format(LLAP_SUMMARY_HEADER_FORMAT, vertexName, selectedRowgroups, metadataCacheHit, metadataCacheMiss, Utilities.humanReadableByteCount(cacheHitBytes), Utilities.humanReadableByteCount(cacheMissBytes), this.secondsFormatter.format((double)totalIoTime / 1.0E9) + "s");
    }

    private TezCounters vertexCounter(Set<StatusGetOpts> statusOptions, String vertexName) {
        try {
            return this.dagClient.getVertexStatus(vertexName, statusOptions).getVertexCounters();
        }
        catch (IOException | TezException throwable) {
            return null;
        }
    }
}

