/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class CastDateToTimestamp
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;

    public CastDateToTimestamp(int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
    }

    public CastDateToTimestamp() {
        this.colNum = -1;
    }

    private void setDays(TimestampColumnVector timestampColVector, long[] vector, int elementNum) {
        timestampColVector.getScratchTimestamp().setTime(DateWritableV2.daysToMillis((int)((int)vector[elementNum])));
        timestampColVector.setFromScratchTimestamp(elementNum);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.setDays(outputColVector, vector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.setDays(outputColVector, vector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.setDays(outputColVector, vector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.setDays(outputColVector, vector, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.setDays(outputColVector, vector, i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    this.setDays(outputColVector, vector, i);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

