/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringSubstrColStartLen
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private final int startIdx;
    private final int length;
    private final int[] offsetArray;
    private static transient byte[] EMPTY_STRING;

    public StringSubstrColStartLen(int colNum, int startIdx, int length, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.offsetArray = new int[2];
        this.startIdx = startIdx >= 1 ? startIdx - 1 : (startIdx == 0 ? 0 : startIdx);
        this.length = length;
    }

    public StringSubstrColStartLen() {
        this.colNum = -1;
        this.startIdx = -1;
        this.length = 0;
        this.offsetArray = null;
    }

    static void populateSubstrOffsets(byte[] utf8String, int start, int len, int substrStart, int substrLength, int[] offsetArray) {
        int i;
        int curIdx = -1;
        offsetArray[0] = -1;
        offsetArray[1] = -1;
        int end = start + len;
        if (substrStart < 0) {
            int length = 0;
            for (i = start; i != end; ++i) {
                if ((utf8String[i] & 0xC0) == 128) continue;
                ++length;
            }
            if (-substrStart > length) {
                return;
            }
            substrStart = length + substrStart;
        }
        if (substrLength == 0) {
            return;
        }
        int endIdx = substrStart + substrLength - 1;
        for (i = start; i != end; ++i) {
            if ((utf8String[i] & 0xC0) == 128) continue;
            if (++curIdx == substrStart) {
                offsetArray[0] = i;
                continue;
            }
            if (curIdx - 1 != endIdx) continue;
            offsetArray[1] = i - offsetArray[0];
        }
        if (offsetArray[1] == -1) {
            offsetArray[1] = end - offsetArray[0];
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int n = batch.size;
        if (n == 0) {
            return;
        }
        byte[][] vector = inV.vector;
        int[] sel = batch.selected;
        int[] len = inV.length;
        int[] start = inV.start;
        outputColVector.initBuffer();
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        if (inV.isRepeating) {
            if (inV.noNulls || !inV.isNull[0]) {
                outputIsNull[0] = false;
                StringSubstrColStartLen.populateSubstrOffsets(vector[0], start[0], len[0], this.startIdx, this.length, this.offsetArray);
                if (this.offsetArray[0] != -1) {
                    outputColVector.setVal(0, vector[0], this.offsetArray[0], this.offsetArray[1]);
                } else {
                    outputColVector.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
                outputColVector.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (batch.selectedInUse) {
            if (!inV.noNulls) {
                for (int i = 0; i != n; ++i) {
                    int selected = sel[i];
                    if (!inV.isNull[selected]) {
                        outputIsNull[selected] = false;
                        StringSubstrColStartLen.populateSubstrOffsets(vector[selected], start[selected], len[selected], this.startIdx, this.length, this.offsetArray);
                        if (this.offsetArray[0] != -1) {
                            outputColVector.setVal(selected, vector[selected], this.offsetArray[0], this.offsetArray[1]);
                            continue;
                        }
                        outputColVector.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                        continue;
                    }
                    outputIsNull[selected] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    int selected = sel[i];
                    outputColVector.isNull[selected] = false;
                    StringSubstrColStartLen.populateSubstrOffsets(vector[selected], start[selected], len[selected], this.startIdx, this.length, this.offsetArray);
                    if (this.offsetArray[0] != -1) {
                        outputColVector.setVal(selected, vector[selected], this.offsetArray[0], this.offsetArray[1]);
                        continue;
                    }
                    outputColVector.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            }
        } else if (!inV.noNulls) {
            for (int i = 0; i != n; ++i) {
                if (!inV.isNull[i]) {
                    outputIsNull[i] = false;
                    StringSubstrColStartLen.populateSubstrOffsets(vector[i], start[i], len[i], this.startIdx, this.length, this.offsetArray);
                    if (this.offsetArray[0] != -1) {
                        outputColVector.setVal(i, vector[i], this.offsetArray[0], this.offsetArray[1]);
                        continue;
                    }
                    outputColVector.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            if (!outputColVector.noNulls) {
                Arrays.fill(outputIsNull, false);
                outputColVector.noNulls = true;
            }
            for (int i = 0; i != n; ++i) {
                StringSubstrColStartLen.populateSubstrOffsets(vector[i], start[i], len[i], this.startIdx, this.length, this.offsetArray);
                if (this.offsetArray[0] != -1) {
                    outputColVector.setVal(i, vector[i], this.offsetArray[0], this.offsetArray[1]);
                    continue;
                }
                outputColVector.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", start " + this.startIdx + ", length " + this.length;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }

    static {
        try {
            EMPTY_STRING = "".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

