/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ITimestampInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TimestampColumnInList
extends VectorExpression
implements ITimestampInExpr {
    private static final long serialVersionUID = 1L;
    private final int inputCol;
    private Timestamp[] inListValues;
    private transient HashSet<Timestamp> inSet;

    public TimestampColumnInList() {
        this.inputCol = -1;
    }

    public TimestampColumnInList(int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new HashSet(this.inListValues.length);
            for (Timestamp val : this.inListValues) {
                this.inSet.add(val);
            }
        }
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputCol];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = this.inSet.contains(inputColVector.asScratchTimestamp(0)) ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.contains(inputColVector.asScratchTimestamp(i)) ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setInListValues(Timestamp[] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputCol) + ", values " + Arrays.toString(this.inListValues);
    }
}

