/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprIntervalDayTimeColumnScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private final int arg2Column;
    private final HiveIntervalDayTime arg3Scalar;

    public IfExprIntervalDayTimeColumnScalar(int arg1Column, int arg2Column, HiveIntervalDayTime arg3Scalar, int outputColumnNum) {
        super(outputColumnNum);
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Scalar = arg3Scalar;
    }

    public IfExprIntervalDayTimeColumnScalar() {
        this.arg1Column = -1;
        this.arg2Column = -1;
        this.arg3Scalar = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        IntervalDayTimeColumnVector arg2ColVector = (IntervalDayTimeColumnVector)batch.cols[this.arg2Column];
        boolean[] arg2IsNull = arg2ColVector.isNull;
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, (ColumnVector)outputColVector);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        if (!arg2IsNull[i]) {
                            outputIsNull[i] = false;
                            outputColVector.set(i, arg2ColVector.asScratchIntervalDayTime(i));
                            continue;
                        }
                        outputIsNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg3Scalar);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        if (!arg2IsNull[i]) {
                            outputIsNull[i] = false;
                            outputColVector.set(i, arg2ColVector.asScratchIntervalDayTime(i));
                            continue;
                        }
                        outputIsNull[i] = true;
                        outputColVector.noNulls = false;
                        continue;
                    }
                    outputIsNull[i] = false;
                    outputColVector.set(i, this.arg3Scalar);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg2ColVector.asScratchIntervalDayTime(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = false;
                outputColVector.set(i, this.arg3Scalar);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    if (!arg2IsNull[i]) {
                        outputIsNull[i] = false;
                        outputColVector.set(i, arg2ColVector.asScratchIntervalDayTime(i));
                        continue;
                    }
                    outputIsNull[i] = true;
                    outputColVector.noNulls = false;
                    continue;
                }
                outputIsNull[i] = false;
                outputColVector.set(i, this.arg3Scalar);
            }
        }
        arg2ColVector.unFlatten();
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.arg1Column) + ", " + this.getColumnParamString(1, this.arg2Column) + ", val " + this.arg3Scalar;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("int_family"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

