/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.io.IOException;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SlidingFilenameRolloverStrategy", category="Core", printObject=true)
public class SlidingFilenameRolloverStrategy
implements RolloverStrategy,
DirectFileRolloverStrategy {
    @PluginFactory
    public static SlidingFilenameRolloverStrategy createStrategy(@PluginConfiguration Configuration config) {
        return new SlidingFilenameRolloverStrategy();
    }

    public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
        AbstractAction shiftToNextActiveFile = new AbstractAction(){

            public boolean execute() throws IOException {
                return true;
            }
        };
        return new RolloverDescriptionImpl("ignored", false, (Action)shiftToNextActiveFile, null);
    }

    public String getCurrentFileName(RollingFileManager rollingFileManager) {
        String pattern = rollingFileManager.getPatternProcessor().getPattern();
        return SlidingFilenameRolloverStrategy.getLogFileName(pattern);
    }

    private static String getLogFileName(String oldFileName) {
        return oldFileName + "." + Long.toString(System.currentTimeMillis());
    }
}

